package play.modules.nemrod;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.ConfigurationException;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.NemrodClient;

public class Nemrod
{

    /**
     * @param args
     * @throws ConfigurationException 
     * @throws ParseException 
     */
    public static void main(String[] args) throws Exception 
    {
        // create Options object
        Options options = new Options();
        
        
        Option action   = OptionBuilder.withArgName( "action" )
                            .hasArg(true)
                            .isRequired(true)
                            .withDescription(  "Action" )
                            .create("a");

        options.addOption(action);
        
        CommandLineParser parser = new PosixParser();
        CommandLine cmd=null;
        try
        {
            cmd = parser.parse( options, args);
        } catch (ParseException e)
        {
            HelpFormatter helpFormatter = new HelpFormatter( );
            helpFormatter.setWidth( 80 );
            helpFormatter.printHelp( "See options below", "Nemrod options:", options, "" );
            System.exit(1);
        }
        
        NemrodConfiguration conf = new NemrodConfiguration();
        
        INemrodClient client = new NemrodClient(conf.getUrl(), conf.getApiKey());
        
        if (cmd.getOptionValue("a").equals("export"))
        {
            ExportAction exportAction = new ExportAction(conf,client);
            exportAction.execute();
        }
        else if (cmd.getOptionValue("a").equals("sync"))
        {
            SyncAction syncAction = new SyncAction(conf,client);
            syncAction.execute();
        }
    }
}
