/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.ShellSettings;
import org.neo4j.shell.impl.ShellBootstrap;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public final class ShellServerExtension
extends KernelExtension<GraphDatabaseShellServer> {
    static final String KEY = "shell";

    public ShellServerExtension() {
        super(KEY);
    }

    @Override
    public Class getSettingsClass() {
        return ShellSettings.class;
    }

    @Override
    protected GraphDatabaseShellServer load(KernelData kernel) {
        return this.loadShell(kernel, new ShellBootstrap(kernel));
    }

    @Override
    protected ShellBootstrap agentArgument(String agentArg) {
        return ShellBootstrap.deserialize(agentArg);
    }

    @Override
    protected GraphDatabaseShellServer agentLoad(KernelData kernel, Object param) {
        return this.loadShell(kernel, (ShellBootstrap)param);
    }

    private GraphDatabaseShellServer loadShell(KernelData kernel, ShellBootstrap bootstrap) {
        try {
            return bootstrap.load(kernel.graphDatabase());
        }
        catch (RemoteException cause) {
            throw new RuntimeException("Could not load remote shell", cause);
        }
    }

    @Override
    protected void agentVisit(KernelData kernel, GraphDatabaseShellServer state, Object param) {
        ((ShellBootstrap)param).visit(state);
    }

    @Override
    protected void unload(GraphDatabaseShellServer server) {
        try {
            server.shutdown();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ShellServer getShellServer(KernelData kernel) {
        return (ShellServer)this.getState(kernel);
    }
}

