/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

public class Mknode
extends GraphDatabaseApp {
    public Mknode() {
        this.addOptionDefinition("np", new OptionDefinition(OptionValueType.MUST, "Properties (a json map) to set for the new node (if one is created)"));
        this.addOptionDefinition("cd", new OptionDefinition(OptionValueType.NONE, "Go to the created node, like doing 'cd'"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose mode: display created node"));
    }

    @Override
    public String getDescription() {
        return "Creates a new node, f.ex:\nmknode --cd --np \"{'name':'Neo'}\"";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws Exception {
        AbstractGraphDatabase db = (AbstractGraphDatabase)this.getServer().getDb();
        Node node = null;
        node = db.createNode();
        this.setProperties(node, parser.option("np", null));
        if (parser.options().containsKey("cd")) {
            this.cdTo(session, node);
        }
        if (parser.options().containsKey("v")) {
            out.println((Serializable)((Object)("Node " + Mknode.getDisplayName(this.getServer(), session, node, false) + " created")));
        }
        return null;
    }
}

