/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.tooling.GlobalGraphOperations;

public class Rmrel
extends GraphDatabaseApp {
    public Rmrel() {
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.NONE, "Force deletion, i.e. disables the connectedness check"));
        this.addOptionDefinition("d", new OptionDefinition(OptionValueType.NONE, "Also delete the node on the other side of the relationship if removing this relationship results in it not having any relationships left"));
    }

    @Override
    public String getDescription() {
        return "Deletes a relationship, also ensuring the connectedness of the graph. That check can be ignored with -f\nUsage: rmrel <relationship id>\n   or  rmrel -f <relationship id>";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        boolean deleteOtherNodeIfEmpty;
        this.assertCurrentIsNode(session);
        if (parser.arguments().isEmpty()) {
            throw new ShellException("Must supply relationship id to delete as the first argument");
        }
        Node currentNode = this.getCurrent(session).asNode();
        Relationship rel = this.findRel(currentNode, Long.parseLong(parser.arguments().get(0)));
        rel.delete();
        Node otherNode = rel.getOtherNode(currentNode);
        boolean forceDeletion = parser.options().containsKey("f");
        if (!forceDeletion) {
            this.ensureConnectedness(otherNode);
            this.ensureConnectedness(currentNode);
        }
        if ((deleteOtherNodeIfEmpty = parser.options().containsKey("d")) && !otherNode.hasRelationship()) {
            out.println((Serializable)((Object)("Also deleted " + Rmrel.getDisplayName(this.getServer(), session, otherNode, false) + " due to it not having any relationships left")));
            otherNode.delete();
        }
        return null;
    }

    private void ensureConnectedness(Node otherNode) throws ShellException {
        if (!this.hasPathToRefNode(otherNode)) {
            throw new ShellException("It would result in " + otherNode + " to be recursively decoupled with the reference node. Use -f to disable this check");
        }
    }

    private Relationship findRel(Node currentNode, long relId) throws ShellException {
        Relationship rel = this.getServer().getDb().getRelationshipById(relId);
        if (rel.getStartNode().equals(currentNode) || rel.getEndNode().equals(currentNode)) {
            return rel;
        }
        throw new ShellException("No relationship " + relId + " connected to " + currentNode);
    }

    private Iterable<RelationshipType> getAllRelationshipTypes() {
        return GlobalGraphOperations.at(this.getServer().getDb()).getAllRelationshipTypes();
    }

    private boolean hasPathToRefNode(Node node) {
        ArrayList<Object> filterList = new ArrayList<Object>();
        for (RelationshipType rel : this.getAllRelationshipTypes()) {
            filterList.add(rel);
            filterList.add((Object)Direction.BOTH);
        }
        Node refNode = this.getServer().getDb().getReferenceNode();
        Traverser traverser = node.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, filterList.toArray());
        for (Node testNode : traverser) {
            if (!refNode.equals(testNode)) continue;
            return true;
        }
        return false;
    }
}

