/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import org.neo4j.graphdb.Node;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.exceptions.UnexpectedException;
import play.modules.neo4j.annotation.Neo4jRelatedTo;
import play.modules.neo4j.annotation.Neo4jUniqueRelation;

public class Neo4jModelEnhancer
extends Enhancer {
    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        String entityName = ctClass.getName();
        Logger.debug((String)("Enhance class " + entityName), (Object[])new Object[0]);
        if (!ctClass.subtypeOf(this.classPool.get("play.modules.neo4j.model.Neo4jModel"))) {
            return;
        }
        try {
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                if (ctConstructor.getParameterTypes().length == 0) {
                    ctClass.removeConstructor(ctConstructor);
                }
                if (ctConstructor.getParameterTypes().length != 1 || !ctConstructor.getParameterTypes()[0].getClass().isInstance(Node.class)) continue;
                ctClass.removeConstructor(ctConstructor);
            }
            if (!ctClass.isInterface()) {
                Logger.debug((String)"Adding default constructor", (Object[])new Object[0]);
                CtConstructor defaultConstructor = CtNewConstructor.make((String)("public " + ctClass.getSimpleName() + "() { super();}"), (CtClass)ctClass);
                ctClass.addConstructor(defaultConstructor);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error in PropertiesEnhancer", (Object[])new Object[0]);
            throw new UnexpectedException("Error in PropertiesEnhancer", (Throwable)e);
        }
        for (CtConstructor ctConstructor : ctClass.getDeclaredFields()) {
            try {
                Neo4jUniqueRelation uniqueRelation;
                String propertyName = ctConstructor.getName().substring(0, 1).toUpperCase() + ctConstructor.getName().substring(1);
                String getter = "get" + propertyName;
                String setter = "set" + propertyName;
                Logger.debug((String)("Field " + ctConstructor.getName() + " is a property ?"), (Object[])new Object[0]);
                if (this.isProperty((CtField)ctConstructor)) {
                    String code;
                    CtMethod ctMethod;
                    Logger.debug((String)"true", (Object[])new Object[0]);
                    try {
                        ctMethod = ctClass.getDeclaredMethod(getter);
                        if (!ctMethod.getName().equalsIgnoreCase("getShouldBeSave")) {
                            ctClass.removeMethod(ctMethod);
                            throw new NotFoundException("it's not a true getter !");
                        }
                    }
                    catch (NotFoundException noGetter) {
                        Logger.debug((String)("Adding getter " + getter + " for class " + entityName), (Object[])new Object[0]);
                        code = "public " + ctConstructor.getType().getName() + " " + getter + "() {" + "if(this.shouldBeSave == Boolean.FALSE && this.node != null){" + "return ((" + ctConstructor.getType().getName() + ") play.modules.neo4j.util.Binder.bindFromNeo4jFormat(this.node.getProperty(\"" + ctConstructor.getName() + "\", null)," + ctConstructor.getType().getName() + ".class ));" + "}else{" + "return " + ctConstructor.getName() + ";" + "}" + "}";
                        Logger.debug((String)code, (Object[])new Object[0]);
                        CtMethod getMethod = CtMethod.make((String)code, (CtClass)ctClass);
                        ctClass.addMethod(getMethod);
                    }
                    try {
                        ctMethod = ctClass.getDeclaredMethod(setter);
                        if (ctMethod.getParameterTypes().length == 1 && ctMethod.getParameterTypes()[0].equals(ctConstructor.getType()) && !Modifier.isStatic(ctMethod.getModifiers()) && !this.hasPlayPropertiesAccessorAnnotation(ctMethod)) continue;
                        if (this.hasPlayPropertiesAccessorAnnotation(ctMethod)) {
                            ctClass.removeMethod(ctMethod);
                        }
                        throw new NotFoundException("it's not a true setter !");
                    }
                    catch (NotFoundException noSetter) {
                        Logger.debug((String)("Adding setter " + setter + " for class " + entityName), (Object[])new Object[0]);
                        code = "public void " + setter + "(" + ctConstructor.getType().getName() + " value) { " + "this." + ctConstructor.getName() + " = value;" + "this.shouldBeSave = Boolean.TRUE;" + "}";
                        CtMethod setMethod = CtMethod.make((String)code, (CtClass)ctClass);
                        Logger.debug((String)code, (Object[])new Object[0]);
                        ctClass.addMethod(setMethod);
                    }
                    continue;
                }
                if (!this.hasNeo4jRelationAnnotation((CtField)ctConstructor)) continue;
                Neo4jRelatedTo relatedTo = this.getRelatedAnnotation((CtField)ctConstructor);
                if (relatedTo != null) {
                    CtMethod ctMethod = ctClass.getDeclaredMethod(getter);
                    ctClass.removeMethod(ctMethod);
                    String code = relatedTo.lazy() ? "public " + ctConstructor.getType().getName() + " " + getter + "() {" + "if(this." + ctConstructor.getName() + " == null){" + "java.lang.reflect.Field field = this.getClass().getField(\"" + ctConstructor.getName() + "\");" + "this." + ctConstructor.getName() + "=play.modules.neo4j.relationship.Neo4jRelationFactory.getModelsFromRelation(\"" + relatedTo.value() + "\", \"" + relatedTo.direction() + "\", field, this.node);" + "}" + "return " + ctConstructor.getName() + ";" + "}" : "public " + ctConstructor.getType().getName() + " " + getter + "() {" + "return " + ctConstructor.getName() + ";" + "}";
                    Logger.debug((String)code, (Object[])new Object[0]);
                    CtMethod method = CtMethod.make((String)code, (CtClass)ctClass);
                    ctClass.addMethod(method);
                }
                if ((uniqueRelation = this.getUniqueRelationAnnotation((CtField)ctConstructor)) == null) continue;
                CtMethod ctMethod = ctClass.getDeclaredMethod(getter);
                ctClass.removeMethod(ctMethod);
                String code = "public " + ctConstructor.getType().getName() + " " + getter + "() {" + "return (" + ctConstructor.getType().getName() + ")" + ctConstructor.getName() + ";" + "}";
                Logger.debug((String)code, (Object[])new Object[0]);
                CtMethod method = CtMethod.make((String)code, (CtClass)ctClass);
                ctClass.addMethod(method);
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Error in PropertiesEnhancer", (Object[])new Object[0]);
                throw new UnexpectedException("Error in PropertiesEnhancer", (Throwable)e);
            }
        }
        Logger.debug((String)("Adding getByKey() method for class " + entityName), (Object[])new Object[0]);
        String codeGetByKey = "public static play.modules.neo4j.model.Neo4jModel getByKey(Long key) throws play.modules.neo4j.exception.Neo4jException {return (" + entityName + ")_getByKey(key, \"" + entityName + "\");" + "}";
        Logger.debug((String)codeGetByKey, (Object[])new Object[0]);
        CtMethod getByKeyMethod = CtMethod.make((String)codeGetByKey, (CtClass)ctClass);
        ctClass.addMethod(getByKeyMethod);
        String codeFindAll = "public static java.util.List findAll() {return " + entityName + "._findAll(\"" + entityName + "\");" + "}";
        Logger.debug((String)codeFindAll, (Object[])new Object[0]);
        CtMethod ctMethod = CtMethod.make((String)codeFindAll, (CtClass)ctClass);
        ctClass.addMethod(ctMethod);
        String queryIndex = "public static java.util.List queryIndex(String indexname, String query) {return " + entityName + "._queryIndex(indexname, query);" + "}";
        Logger.debug((String)queryIndex, (Object[])new Object[0]);
        CtMethod queryIndexMethod = CtMethod.make((String)queryIndex, (CtClass)ctClass);
        ctClass.addMethod(queryIndexMethod);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    private boolean isProperty(CtField ctField) {
        if (ctField.getName().equals(ctField.getName().toUpperCase()) || ctField.getName().substring(0, 1).equals(ctField.getName().substring(0, 1).toUpperCase())) {
            return false;
        }
        if (this.hasNeo4jRelationAnnotation(ctField)) {
            return false;
        }
        return Modifier.isPublic(ctField.getModifiers()) && !Modifier.isFinal(ctField.getModifiers()) && !Modifier.isStatic(ctField.getModifiers());
    }

    private boolean hasPlayPropertiesAccessorAnnotation(CtMethod ctMethod) {
        for (Object object : ctMethod.getAvailableAnnotations()) {
            Annotation ann = (Annotation)object;
            Logger.debug((String)("Annotation method is " + ann.annotationType().getName()), (Object[])new Object[0]);
            if (!ann.annotationType().getName().equals("play.classloading.enhancers.PropertiesEnhancer$PlayPropertyAccessor")) continue;
            Logger.debug((String)("Method " + ctMethod.getName() + " has be enhanced by propertiesEnhancer"), (Object[])new Object[0]);
            return true;
        }
        Logger.debug((String)("Method " + ctMethod.getName() + " has not be enhance by propertiesEnhancer"), (Object[])new Object[0]);
        return false;
    }

    private boolean hasNeo4jRelationAnnotation(CtField ctField) {
        for (Object info : ctField.getAvailableAnnotations()) {
            String annotationName = info.toString();
            if (!annotationName.startsWith("@play.modules.neo4j.annotation.Neo4jRelatedTo") && !annotationName.startsWith("@play.modules.neo4j.annotation.Neo4jRelatedToVia") && !annotationName.startsWith("@play.modules.neo4j.annotation.Neo4jUniqueRelation")) continue;
            return true;
        }
        return false;
    }

    private Neo4jRelatedTo getRelatedAnnotation(CtField ctField) {
        for (Object annotation : ctField.getAvailableAnnotations()) {
            if (!annotation.toString().startsWith("@play.modules.neo4j.annotation.Neo4jRelatedTo(")) continue;
            return (Neo4jRelatedTo)annotation;
        }
        return null;
    }

    private Neo4jUniqueRelation getUniqueRelationAnnotation(CtField ctField) {
        for (Object annotation : ctField.getAvailableAnnotations()) {
            if (!annotation.toString().startsWith("@play.modules.neo4j.annotation.Neo4jUniqueRelation(")) continue;
            return (Neo4jUniqueRelation)annotation;
        }
        return null;
    }
}

