/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.relationship;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import play.Logger;
import play.modules.neo4j.exception.Neo4jPlayException;
import play.modules.neo4j.model.Neo4jModel;

public class Neo4jRelationFactory {
    public static <T extends Neo4jModel> List<T> getModelsFromRelation(String relationName, String direction, Field field, Node node) {
        ArrayList list;
        block4: {
            list = new ArrayList();
            try {
                if (field.getType().isAssignableFrom(List.class)) {
                    node.getRelationships(Direction.valueOf((String)direction), new RelationshipType[]{DynamicRelationshipType.withName((String)relationName)}).iterator();
                    for (Relationship relation : node.getRelationships(Direction.valueOf((String)direction), new RelationshipType[]{DynamicRelationshipType.withName((String)relationName)})) {
                        Node item = relation.getEndNode();
                        Object nodeWrapper = Neo4jModel.getByNode(item);
                        list.add(nodeWrapper);
                    }
                    break block4;
                }
                throw new Neo4jPlayException("Field with 'Neo4jRelatedTo' annotation must be a List");
            }
            catch (Exception e) {
                throw new Neo4jPlayException(e);
            }
        }
        return list;
    }

    public static <T extends Neo4jModel> T getModelFromUniqueRelation(String relationName, String direction, Field field, Node node) {
        T nodeWrapper;
        block5: {
            nodeWrapper = null;
            try {
                if (Neo4jModel.class.isAssignableFrom(field.getType())) {
                    for (Relationship relation : node.getRelationships((RelationshipType)DynamicRelationshipType.withName((String)relationName), Direction.valueOf((String)direction))) {
                        if (nodeWrapper == null) {
                            Node item = relation.getEndNode();
                            nodeWrapper = Neo4jModel.getByNode(item);
                            Logger.debug((String)("Loading neo4j single '" + relation.getType().name() + "-" + relation.getId() + "' (" + direction + ") node for node " + node.getId()), (Object[])new Object[0]);
                            continue;
                        }
                        throw new Neo4jPlayException("Field " + field.getName() + " of node " + node.getId() + " that has a 'Neo4jUniqueRelation' have multiple related node ... it's incompatible !!!");
                    }
                    break block5;
                }
                throw new Neo4jPlayException("Field with 'Neo4jUniqueRelation' annotation must be a Neo4jModel");
            }
            catch (Exception e) {
                throw new Neo4jPlayException(e);
            }
        }
        return nodeWrapper;
    }
}

