/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.io.graphson;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.io.graphson.GraphSONFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.MappingJsonFactory;

public class GraphSONWriter {
    private final Graph graph;

    public GraphSONWriter(Graph graph) {
        this.graph = graph;
    }

    public void outputGraph(OutputStream jsonOutputStream, List<String> edgePropertyKeys, List<String> vertexPropertyKeys, boolean showTypes) throws IOException {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        JsonGenerator jg = jsonFactory.createJsonGenerator(jsonOutputStream);
        jg.writeStartObject();
        if (showTypes) {
            jg.writeBooleanField("embeddedTypes", showTypes);
        }
        jg.writeArrayFieldStart("vertices");
        for (Vertex v : this.graph.getVertices()) {
            jg.writeTree((JsonNode)GraphSONFactory.createJSONElementAsObjectNode(v, vertexPropertyKeys, showTypes));
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("edges");
        for (Edge e : this.graph.getEdges()) {
            jg.writeTree((JsonNode)GraphSONFactory.createJSONElementAsObjectNode(e, edgePropertyKeys, showTypes));
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        jg.close();
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, false);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, boolean showTypes) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, null, null, showTypes);
    }

    public static void outputGraph(Graph graph, OutputStream jsonOutputStream, List<String> edgePropertyKeys, List<String> vertexPropertyKeys, boolean showTypes) throws IOException {
        GraphSONWriter writer = new GraphSONWriter(graph);
        writer.outputGraph(jsonOutputStream, edgePropertyKeys, vertexPropertyKeys, showTypes);
    }
}

