/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.ReadOnlyIdGenerator;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class CommonAbstractStore {
    public static final String ALL_STORES_VERSION = "v0.A.0";
    public static final String UNKNOWN_VERSION = "Uknown";
    protected static final Logger logger = Logger.getLogger(CommonAbstractStore.class.getName());
    protected Config configuration;
    protected IdGeneratorFactory idGeneratorFactory;
    protected FileSystemAbstraction fileSystemAbstraction;
    protected final String storageFileName;
    private final IdType idType;
    protected StringLogger stringLogger;
    private IdGenerator idGenerator = null;
    private FileChannel fileChannel = null;
    private PersistenceWindowPool windowPool;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private FileLock fileLock;
    private boolean grabFileLock = true;
    private boolean readOnly = false;
    private boolean backupSlave = false;
    private long highestUpdateRecordId = -1L;
    private boolean isRecovered = false;

    public CommonAbstractStore(String fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.idType = idType;
        this.stringLogger = stringLogger;
        this.grabFileLock = configuration.getBoolean(Configuration.grab_file_lock);
        this.checkStorage();
        this.checkVersion();
        this.loadStorage();
    }

    public String getTypeAndVersionDescriptor() {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + ALL_STORES_VERSION;
    }

    protected long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public abstract String getTypeDescriptor();

    protected void checkStorage() {
        this.readOnly = this.configuration.getBoolean(Configuration.read_only);
        this.backupSlave = this.configuration.getBoolean(Configuration.backup_slave);
        if (!this.fileSystemAbstraction.fileExists(this.storageFileName)) {
            throw new IllegalStateException("No such store[" + this.storageFileName + "]");
        }
        try {
            this.fileChannel = this.fileSystemAbstraction.open(this.storageFileName, this.readOnly ? "r" : "rw");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
        try {
            if ((!this.readOnly || this.backupSlave) && this.grabFileLock) {
                this.fileLock = this.fileSystemAbstraction.tryLock(this.storageFileName, this.fileChannel);
                if (this.fileLock == null) {
                    throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually a result of some " + "other Neo4j kernel running using the same store.");
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.storageFileName + "]", e);
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    protected void checkVersion() {
        try {
            this.verifyCorrectTypeDescriptorAndVersion();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    protected void loadStorage() {
        try {
            this.readAndVerifyBlockSize();
            this.verifyFileSizeAndTruncate();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
        this.loadIdGenerator();
        this.setWindowPool(new PersistenceWindowPool(this.getStorageFileName(), this.getEffectiveRecordSize(), this.getFileChannel(), this.calculateMappedMemory(this.configuration.getParams(), this.storageFileName), this.configuration.getBoolean(Configuration.use_memory_mapped_buffers), this.isReadOnly() && !this.isBackupSlave()));
    }

    protected abstract int getEffectiveRecordSize();

    protected abstract void verifyFileSizeAndTruncate() throws IOException;

    protected abstract void readAndVerifyBlockSize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIdGenerator() {
        try {
            if (!this.isReadOnly() || this.isBackupSlave()) {
                this.openIdGenerator(true);
            } else {
                this.openReadOnlyIdGenerator(this.getEffectiveRecordSize());
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk() && this.stringLogger != null) {
                this.stringLogger.logMessage(this.getStorageFileName() + " non clean shutdown detected", true);
            }
        }
    }

    protected void verifyCorrectTypeDescriptorAndVersion() throws IOException {
        String expectedTypeDescriptorAndVersion = this.getTypeAndVersionDescriptor();
        int length = UTF8.encode(expectedTypeDescriptorAndVersion).length;
        byte[] bytes = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long fileSize = this.getFileChannel().size();
        if (fileSize >= (long)length) {
            this.getFileChannel().position(fileSize - (long)length);
        } else if (!this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Invalid file size " + fileSize + " for " + this + ". Expected " + length + " or bigger"));
            return;
        }
        this.getFileChannel().read(buffer);
        String foundTypeDescriptorAndVersion = UTF8.decode(bytes);
        if (!expectedTypeDescriptorAndVersion.equals(foundTypeDescriptorAndVersion) && !this.isReadOnly()) {
            if (foundTypeDescriptorAndVersion.startsWith(this.getTypeDescriptor())) {
                throw new NotCurrentStoreVersionException(ALL_STORES_VERSION, foundTypeDescriptorAndVersion, "", false);
            }
            this.setStoreNotOk(new IllegalStateException("Unexpected version " + foundTypeDescriptorAndVersion + ", expected " + expectedTypeDescriptorAndVersion));
        }
    }

    protected abstract void rebuildIdGenerator();

    protected void closeStorage() {
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    protected void setStoreNotOk(Throwable cause) {
        if (this.readOnly && !this.isBackupSlave()) {
            throw new UnderlyingStorageException("Cannot start up on non clean store as read only");
        }
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void setWindowPool(PersistenceWindowPool pool) {
        this.windowPool = pool;
    }

    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        this.idGenerator.freeId(id);
    }

    public long getHighId() {
        long updateHighId = this.highestUpdateRecordId;
        long genHighId = this.idGenerator != null ? this.idGenerator.getHighId() : -1L;
        if (updateHighId > genHighId) {
            return updateHighId;
        }
        return genHighId;
    }

    public void setHighId(long highId) {
        if (this.idGenerator != null) {
            this.idGenerator.setHighId(highId);
        }
    }

    private long calculateMappedMemory(Map<?, ?> config, String storageFileName) {
        String convertSlash = storageFileName.replace('\\', '/');
        String realName = convertSlash.substring(convertSlash.lastIndexOf(47) + 1);
        String mem = (String)config.get(realName + ".mapped_memory");
        if (mem != null) {
            long multiplier = 1L;
            if ((mem = mem.trim().toLowerCase()).endsWith("m")) {
                multiplier = 0x100000L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("k")) {
                multiplier = 1024L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("g")) {
                multiplier = 0x40000000L;
                mem = mem.substring(0, mem.length() - 1);
            }
            try {
                return (long)Integer.parseInt(mem) * multiplier;
            }
            catch (NumberFormatException e) {
                logger.info("Unable to parse mapped memory[" + mem + "] string for " + storageFileName);
            }
        }
        return 0L;
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            if (this.readOnly && !this.backupSlave) {
                throw new ReadOnlyDbException();
            }
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    public void rebuildIdGenerators() {
        if (this.readOnly && !this.backupSlave) {
            throw new ReadOnlyDbException();
        }
        this.rebuildIdGenerator();
    }

    protected String getStoreDir() {
        return this.configuration.get(Configuration.store_dir);
    }

    protected PersistenceWindow acquireWindow(long position, OperationType type) {
        if (!(this.isInRecoveryMode() || position <= this.getHighId() && this.storeOk)) {
            throw new InvalidRecordException("Position[" + position + "]" + " requested for high id[" + this.getHighId() + "], store is ok[" + this.storeOk + "]" + " recovery[" + this.isInRecoveryMode() + "]", this.causeOfStoreNotOk);
        }
        return this.windowPool.acquire(position, type);
    }

    protected void releaseWindow(PersistenceWindow window) {
        this.windowPool.release(window);
    }

    public void flushAll() {
        this.windowPool.flushAll();
    }

    public boolean isInRecoveryMode() {
        return this.isRecovered;
    }

    protected void setRecovered() {
        this.isRecovered = true;
    }

    protected void unsetRecovered() {
        this.isRecovered = false;
    }

    public String getStorageFileName() {
        return this.storageFileName;
    }

    protected void openIdGenerator(boolean firstTime) {
        this.idGenerator = this.openIdGenerator(this.storageFileName + ".id", this.idType.getGrabSize(), firstTime);
        this.updateHighId();
    }

    protected IdGenerator openIdGenerator(String fileName, int grabSize, boolean firstTime) {
        return this.idGeneratorFactory.open(this.fileSystemAbstraction, fileName, grabSize, this.getIdType(), this.figureOutHighestIdInUse(), firstTime);
    }

    protected abstract long figureOutHighestIdInUse();

    protected void createIdGenerator(String fileName) {
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName);
    }

    protected void openReadOnlyIdGenerator(int recordSize) {
        try {
            this.idGenerator = new ReadOnlyIdGenerator(this.storageFileName + ".id", this.fileChannel.size() / (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close(false);
        }
    }

    public void close() {
        if (this.fileChannel == null) {
            return;
        }
        this.closeStorage();
        if (this.windowPool != null) {
            this.windowPool.close();
            this.windowPool = null;
        }
        if (this.isReadOnly() && !this.isBackupSlave() || this.idGenerator == null || !this.storeOk) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            return;
        }
        long highId = this.idGenerator.getHighId();
        int recordSize = -1;
        if (this instanceof AbstractDynamicStore) {
            recordSize = ((AbstractDynamicStore)this).getBlockSize();
        } else if (this instanceof AbstractStore) {
            recordSize = ((AbstractStore)this).getRecordSize();
        }
        this.idGenerator.close(true);
        boolean success = false;
        IOException storedIoe = null;
        if (!this.readOnly || this.backupSlave) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.fileChannel.position(highId * (long)recordSize);
                    ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode(this.getTypeAndVersionDescriptor()));
                    this.fileChannel.write(buffer);
                    this.fileChannel.truncate(this.fileChannel.position());
                    this.fileChannel.force(false);
                    this.releaseFileLockAndCloseFileChannel();
                    success = true;
                    break;
                }
                catch (IOException e) {
                    storedIoe = e;
                    System.gc();
                    continue;
                }
            }
        } else {
            this.releaseFileLockAndCloseFileChannel();
            success = true;
        }
        if (!success) {
            throw new UnderlyingStorageException("Unable to close store " + this.getStorageFileName(), storedIoe);
        }
    }

    protected void releaseFileLockAndCloseFileChannel() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not close [" + this.storageFileName + "]", e);
        }
        this.fileChannel = null;
    }

    protected final FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getHighestPossibleIdInUse() {
        return this.idGenerator.getHighId() - 1L;
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.windowPool.getStats();
    }

    public IdType getIdType() {
        return this.idType;
    }

    protected void registerIdFromUpdateRecord(long id) {
        this.highestUpdateRecordId = Math.max(this.highestUpdateRecordId, id + 1L);
    }

    protected void updateHighId() {
        long highId = this.highestUpdateRecordId;
        this.highestUpdateRecordId = -1L;
        if (highId > this.getHighId()) {
            this.setHighId(highId);
        }
    }

    public void logVersions(StringLogger.LineLogger logger) {
        logger.logLine("  " + this.getTypeAndVersionDescriptor());
    }

    public void logIdUsage(StringLogger.LineLogger lineLogger) {
        lineLogger.logLine(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.StringSetting store_dir = AbstractGraphDatabase.Configuration.store_dir;
        public static final GraphDatabaseSetting.StringSetting neo_store = AbstractGraphDatabase.Configuration.neo_store;
        public static final GraphDatabaseSetting.BooleanSetting grab_file_lock = GraphDatabaseSettings.grab_file_lock;
        public static final GraphDatabaseSetting.BooleanSetting read_only = GraphDatabaseSettings.read_only;
        public static final GraphDatabaseSetting.BooleanSetting backup_slave = GraphDatabaseSettings.backup_slave;
        public static final GraphDatabaseSetting.BooleanSetting use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
    }
}

