/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.factory.GraphDatabaseSettingsResourceBundle;

public class GenerateNeo4jSettingsAsciidoc {
    public static void main(String[] args) {
        ResourceBundle bundle = ResourceBundle.getBundle(GraphDatabaseSettingsResourceBundle.class.getName());
        Set<String> keys = bundle.keySet();
        for (String property : keys) {
            if (!property.endsWith(".description")) continue;
            String name = property.substring(0, property.lastIndexOf("."));
            System.out.println("." + bundle.getString(name + ".title"));
            String minmax = "";
            if (bundle.containsKey(name + ".min") && bundle.containsKey(name + ".max")) {
                minmax = ",\"minmax\"";
            } else if (bundle.containsKey(name + ".min")) {
                minmax = ",\"minmax\"";
            } else if (bundle.containsKey(name + ".max")) {
                minmax = ",\"minmax\"";
            }
            System.out.println("[\"configsetting\"" + minmax + "]");
            System.out.println("----");
            String defaultKey = name + ".default";
            if (bundle.containsKey(defaultKey)) {
                System.out.println(name + ": " + bundle.getString(defaultKey));
            } else {
                System.out.println(name);
            }
            System.out.println(bundle.getString(property));
            String optionsKey = name + ".options";
            if (bundle.containsKey(optionsKey)) {
                String[] options = bundle.getString(optionsKey).split(",");
                if (bundle.containsKey(name + ".option." + options[0])) {
                    for (String option : options) {
                        String description = bundle.getString(name + ".option." + option);
                        char[] spaces = new char[option.length() + 2];
                        Arrays.fill(spaces, ' ');
                        description = description.replace("\n", " ");
                        System.out.println(option + ": " + description);
                    }
                } else {
                    System.out.println(bundle.getString(optionsKey).replace(",", "\u00a0\n"));
                }
            }
            if (bundle.containsKey(name + ".min")) {
                System.out.println(bundle.getString(name + ".min"));
            }
            if (bundle.containsKey(name + ".max")) {
                System.out.println(bundle.getString(name + ".max"));
            }
            System.out.println("----");
            System.out.println("");
        }
    }
}

