/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.File;
import org.neo4j.shell.Console;
import org.neo4j.shell.ShellClient;

public class JLineConsole
implements Console {
    private Object consoleReader;

    static JLineConsole newConsoleOrNullIfNotFound(ShellClient client) {
        try {
            Object consoleReader = Class.forName("jline.ConsoleReader").newInstance();
            consoleReader.getClass().getMethod("setBellEnabled", Boolean.TYPE).invoke(consoleReader, false);
            consoleReader.getClass().getMethod("setBellEnabled", Boolean.TYPE).invoke(consoleReader, false);
            consoleReader.getClass().getMethod("setUseHistory", Boolean.TYPE).invoke(consoleReader, true);
            Object completor = Class.forName(JLineConsole.class.getPackage().getName() + "." + "ShellTabCompletor").getConstructor(ShellClient.class).newInstance(client);
            Class<?> completorClass = Class.forName("jline.Completor");
            consoleReader.getClass().getMethod("addCompletor", completorClass).invoke(consoleReader, completor);
            Class<?> historyClass = Class.forName("jline.History");
            Object history = historyClass.newInstance();
            history.getClass().getMethod("setHistoryFile", File.class).invoke(history, new File(".shell_history"));
            consoleReader.getClass().getMethod("setHistory", historyClass).invoke(consoleReader, history);
            return new JLineConsole(consoleReader, client);
        }
        catch (Exception e) {
            return null;
        }
    }

    private JLineConsole(Object consoleReader, ShellClient client) {
        this.consoleReader = consoleReader;
    }

    @Override
    public void format(String format, Object ... args) {
        System.out.print(format);
    }

    @Override
    public String readLine(String prompt) {
        try {
            this.consoleReader.getClass().getMethod("setDefaultPrompt", String.class).invoke(this.consoleReader, prompt);
            return (String)this.consoleReader.getClass().getMethod("readLine", new Class[0]).invoke(this.consoleReader, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

