/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.neo4j.kernel.impl.transaction.TransactionImpl;

public class UserTransactionImpl
implements UserTransaction {
    private TransactionManager tm;

    public UserTransactionImpl() {
    }

    public UserTransactionImpl(TransactionManager tm) {
        this.tm = tm;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.tm.setTransactionTimeout(seconds);
    }

    public Integer getEventIdentifier() {
        try {
            TransactionImpl tx = (TransactionImpl)this.tm.getTransaction();
            if (tx != null) {
                return tx.getEventIdentifier();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return null;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }
}

