/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.Traversal;

public class TraversalPath
implements Path {
    private final TraversalBranch branch;
    private LinkedList<Node> nodes;
    private LinkedList<Relationship> relationships;

    TraversalPath(TraversalBranch branch) {
        this.branch = branch;
    }

    private void ensureEntitiesAreGathered() {
        if (this.nodes == null) {
            LinkedList<Node> nodesList = new LinkedList<Node>();
            LinkedList<Relationship> relationshipsList = new LinkedList<Relationship>();
            for (TraversalBranch stepper = this.branch; stepper != null; stepper = stepper.parent()) {
                nodesList.addFirst(stepper.node());
                Relationship relationship = stepper.relationship();
                if (relationship == null) continue;
                relationshipsList.addFirst(relationship);
            }
            this.nodes = nodesList;
            this.relationships = relationshipsList;
        }
    }

    @Override
    public Node startNode() {
        this.ensureEntitiesAreGathered();
        return this.nodes.getFirst();
    }

    @Override
    public Node endNode() {
        return this.branch.node();
    }

    @Override
    public Relationship lastRelationship() {
        return this.branch.relationship();
    }

    @Override
    public Iterable<Node> nodes() {
        this.ensureEntitiesAreGathered();
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> relationships() {
        this.ensureEntitiesAreGathered();
        return this.relationships;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        this.ensureEntitiesAreGathered();
        return new Iterator<PropertyContainer>(){
            Iterator<? extends PropertyContainer> current;
            Iterator<? extends PropertyContainer> next;
            {
                this.current = TraversalPath.this.nodes().iterator();
                this.next = TraversalPath.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropertyContainer next() {
                try {
                    PropertyContainer propertyContainer = this.current.next();
                    return propertyContainer;
                }
                finally {
                    Iterator<? extends PropertyContainer> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    @Override
    public int length() {
        return this.branch.depth();
    }

    @Override
    public String toString() {
        return Traversal.defaultPathToString(this);
    }

    public int hashCode() {
        this.ensureEntitiesAreGathered();
        if (this.relationships.isEmpty()) {
            return this.startNode().hashCode();
        }
        return this.relationships.hashCode();
    }

    public boolean equals(Object obj) {
        this.ensureEntitiesAreGathered();
        if (this == obj) {
            return true;
        }
        if (obj instanceof TraversalPath) {
            TraversalPath other = (TraversalPath)obj;
            return this.startNode().equals(other.startNode()) && this.relationships.equals(other.relationships);
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (this.startNode().equals(other.startNode())) {
                Iterator<Relationship> these = this.relationships().iterator();
                Iterator<Relationship> those = other.relationships().iterator();
                while (these.hasNext() && those.hasNext()) {
                    if (these.next().equals(those.next())) continue;
                    return false;
                }
                return !these.hasNext() && !those.hasNext();
            }
        }
        return false;
    }
}

