/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterable<S>
implements Iterable<S> {
    private final List<Iterable<S>> iterables;

    public MultiIterable(List<Iterable<S>> iterables) {
        this.iterables = iterables;
    }

    @Override
    public Iterator<S> iterator() {
        if (this.iterables.size() == 0) {
            return new ArrayList().iterator();
        }
        return new MultiIterator<S>(this.iterables);
    }

    protected class MultiIterator<S>
    implements Iterator<S> {
        private final List<Iterator<S>> iterators = new ArrayList<Iterator<S>>();
        private int current = 0;

        public MultiIterator(List<Iterable<S>> iterables) {
            for (Iterable<S> iterable : iterables) {
                this.iterators.add(iterable.iterator());
            }
        }

        @Override
        public void remove() {
            this.iterators.get(this.current).remove();
        }

        @Override
        public boolean hasNext() {
            while (this.current < this.iterators.size()) {
                if (this.iterators.get(this.current).hasNext()) {
                    return true;
                }
                ++this.current;
            }
            return false;
        }

        @Override
        public S next() {
            while (this.current < this.iterators.size()) {
                Iterator<S> temp = this.iterators.get(this.current);
                if (temp.hasNext()) {
                    return temp.next();
                }
                ++this.current;
            }
            throw new NoSuchElementException();
        }
    }
}

