/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util;

import com.tinkerpop.blueprints.pgm.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ElementHelper {
    public static void copyProperties(Element from, Element to) {
        for (String key : from.getPropertyKeys()) {
            to.setProperty(key, from.getProperty(key));
        }
    }

    public static void removeProperties(Iterable<Element> elements) {
        for (Element element : elements) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(element.getPropertyKeys());
            for (String key : keys) {
                element.removeProperty(key);
            }
        }
    }

    public static void removeProperty(String key, Iterable<Element> elements) {
        for (Element element : elements) {
            element.removeProperty(key);
        }
    }

    public static void renameProperty(String oldKey, String newKey, Iterable<Element> elements) {
        for (Element element : elements) {
            Object value = element.removeProperty(oldKey);
            if (null == value) continue;
            element.setProperty(newKey, value);
        }
    }

    public static void typecastProperty(String key, Class classCast, Iterable<Element> elements) {
        for (Element element : elements) {
            Object value = element.removeProperty(key);
            if (null == value) continue;
            try {
                element.setProperty(key, classCast.getConstructor(String.class).newInstance(value.toString()));
            }
            catch (Exception e) {
                element.setProperty(key, value);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static boolean haveEqualProperties(Element a, Element b) {
        Set<String> bKeys;
        Set<String> aKeys = a.getPropertyKeys();
        if (aKeys.containsAll(bKeys = b.getPropertyKeys()) && bKeys.containsAll(aKeys)) {
            for (String key : aKeys) {
                if (a.getProperty(key).equals(b.getProperty(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<String, Object> getProperties(Element element) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : element.getPropertyKeys()) {
            properties.put(key, element.getProperty(key));
        }
        return properties;
    }

    public static void setProperties(Element element, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            element.setProperty(property.getKey(), property.getValue());
        }
    }
}

