/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.partition;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionElement;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionVertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.util.PartitionEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.util.PartitionVertexSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PartitionGraph
implements Graph {
    protected Graph rawGraph;
    private String writePartition;
    private Set<String> readPartitions = new HashSet<String>();
    private String partitionKey;

    public PartitionGraph(Graph rawGraph, String partitionKey, String writePartition, Set<String> readPartitions) {
        this.rawGraph = rawGraph;
        this.partitionKey = partitionKey;
        this.writePartition = writePartition;
        this.readPartitions.addAll(readPartitions);
    }

    public PartitionGraph(Graph rawGraph, String partitionKey, String readWriteGraph) {
        this(rawGraph, partitionKey, readWriteGraph, new HashSet<String>(Arrays.asList(readWriteGraph)));
    }

    public String getWritePartition() {
        return this.writePartition;
    }

    public void setWritePartition(String writePartition) {
        this.writePartition = writePartition;
    }

    public Set<String> getReadPartitions() {
        return new HashSet<String>(this.readPartitions);
    }

    public void removeReadGraph(String readGraph) {
        this.readPartitions.remove(readGraph);
    }

    public void addReadGraph(String readGraph) {
        this.readPartitions.add(readGraph);
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public boolean isInPartition(Element element) {
        String writeGraph = element instanceof PartitionElement ? ((PartitionElement)element).getPartition() : (String)element.getProperty(this.partitionKey);
        return null == writeGraph || this.readPartitions.contains(writeGraph);
    }

    @Override
    public void clear() {
        this.rawGraph.clear();
    }

    @Override
    public void shutdown() {
        this.rawGraph.shutdown();
    }

    @Override
    public Vertex addVertex(Object id) {
        PartitionVertex vertex = new PartitionVertex(this.rawGraph.addVertex(id), this);
        vertex.setPartition(this.writePartition);
        return vertex;
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.rawGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        if (this.isInPartition(vertex)) {
            return new PartitionVertex(vertex, this);
        }
        return null;
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new PartitionVertexSequence(this.rawGraph.getVertices().iterator(), this);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        PartitionEdge edge = new PartitionEdge(this.rawGraph.addEdge(id, ((PartitionVertex)outVertex).getRawVertex(), ((PartitionVertex)inVertex).getRawVertex(), label), this);
        edge.setPartition(this.writePartition);
        return edge;
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.rawGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new PartitionEdge(edge, this);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new PartitionEdgeSequence(this.rawGraph.getEdges().iterator(), this);
    }

    @Override
    public void removeEdge(Edge edge) {
        this.rawGraph.removeEdge(((PartitionEdge)edge).getRawEdge());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.rawGraph.removeVertex(((PartitionVertex)vertex).getRawVertex());
    }

    public Graph getRawGraph() {
        return this.rawGraph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.rawGraph.toString());
    }
}

