/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.partition.util;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.partition.PartitionGraph;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PartitionEdgeSequence
implements CloseableSequence<Edge> {
    private final Iterator<Edge> itty;
    private final PartitionGraph graph;
    private PartitionEdge nextEdge;

    public PartitionEdgeSequence(Iterator<Edge> itty, PartitionGraph graph) {
        this.itty = itty;
        this.graph = graph;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (null != this.nextEdge) {
            return true;
        }
        while (this.itty.hasNext()) {
            Edge edge = this.itty.next();
            if (!this.graph.isInPartition(edge)) continue;
            this.nextEdge = new PartitionEdge(edge, this.graph);
            return true;
        }
        return false;
    }

    @Override
    public Edge next() {
        if (null != this.nextEdge) {
            PartitionEdge temp = this.nextEdge;
            this.nextEdge = null;
            return temp;
        }
        while (this.itty.hasNext()) {
            Edge edge = this.itty.next();
            if (!this.graph.isInPartition(edge)) continue;
            return new PartitionEdge(edge, this.graph);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<Edge> iterator() {
        return this;
    }

    @Override
    public void close() {
        if (this.itty instanceof CloseableSequence) {
            ((CloseableSequence)this.itty).close();
        }
    }
}

