/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import play.Play;
import play.db.DBPlugin;
import play.db.jpa.JPAPlugin;
import play.modules.neo4j.cli.export.YmlNode;
import play.modules.neo4j.cli.export.YmlRelation;
import play.modules.neo4j.util.Neo4j;

public class Export {
    public static Map<String, YmlNode> nodes = new HashMap<String, YmlNode>();
    public static Map<String, YmlRelation> relations = new HashMap<String, YmlRelation>();

    public static void main(String[] args) throws Exception {
        String filename = "data";
        String output = "conf/";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--")) continue;
            if (args[i].startsWith("--filename=")) {
                filename = args[i].substring(11);
            }
            if (!args[i].startsWith("--output=")) continue;
            output = args[i].substring(9);
        }
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        Class c = Play.classloader.loadClass("play.modules.neo4j.cli.Export");
        Method m = c.getMethod("mainWork", String.class, String.class);
        m.invoke(c.newInstance(), filename, output);
        System.exit(0);
    }

    public static void mainWork(String filename, String output) throws Exception {
        new DBPlugin().onApplicationStart();
        new JPAPlugin().onApplicationStart();
        Neo4j.initialize();
        for (Node node : Neo4j.db().getAllNodes()) {
            if (!node.hasRelationship(Direction.INCOMING) || node.hasProperty("CLASSNAME") || node.hasProperty("KEY_COUNTER")) continue;
            System.out.println("Adding node " + node.getId());
            YmlNode ymlNode = new YmlNode(node);
            nodes.put(ymlNode.id, ymlNode);
            for (Relationship relation : node.getRelationships(Direction.OUTGOING)) {
                YmlRelation ymlRelation = new YmlRelation(relation);
                relations.put(ymlRelation.id, ymlRelation);
            }
        }
        Export.writeFile(filename, output);
        System.out.println("End of mainWork");
    }

    private static void writeFile(String filename, String output) throws IOException {
        File file = new File(output + "/" + filename + ".yml");
        FileOutputStream fop = new FileOutputStream(file);
        fop.write("# Generated by logisima-play-neo4j (http://github.com/sim51/logisima-play-neo4j).\n".getBytes());
        fop.write("# This module is a part of LogiSima (http://www.logisima.com).\n".getBytes());
        for (YmlNode ymlNode : nodes.values()) {
            System.out.println("Generating node " + ymlNode.id);
            fop.write(ymlNode.toYml().getBytes());
        }
        for (YmlRelation ymlRelation : relations.values()) {
            System.out.println("Generating relation " + ymlRelation.id);
            fop.write(ymlRelation.toYml().getBytes());
        }
        fop.flush();
        fop.close();
    }
}

