/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.cli.export;

import org.neo4j.graphdb.Node;
import play.modules.neo4j.util.Neo4jUtils;

public class YmlNode {
    public String id;
    private Class model;
    private Node dbNode;

    public YmlNode(Node node) {
        this.dbNode = node;
        this.model = Neo4jUtils.getClassNameFromNode(node);
        if (this.dbNode.getProperty("key", null) != null) {
            System.out.println("Model class name " + this.model.getSimpleName());
            this.id = this.model.getSimpleName() + "_" + this.dbNode.getProperty("key").toString();
        } else {
            this.id = "" + this.dbNode.getId();
        }
    }

    public String toYml() {
        String yml = "";
        if (this.id != null) {
            System.out.println("Generate yml for node " + this.id);
            yml = "\n" + this.model.getSimpleName() + "(" + this.id + "):";
            for (String property : this.dbNode.getPropertyKeys()) {
                if (this.dbNode.getProperty(property, null) == null || property.equals("key")) continue;
                yml = yml + "\n " + property + ": '" + this.dbNode.getProperty(property) + "'";
            }
            yml = yml + "\n";
        }
        return yml;
    }
}

