/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.CatchingIteratorWrapper;
import org.neo4j.helpers.collection.IteratorUtil;

public abstract class IdToEntityIterator<T extends PropertyContainer>
extends CatchingIteratorWrapper<T, Long>
implements IndexHits<T> {
    private final IndexHits<Long> ids;
    private final Set<Long> alreadyReturned = new HashSet<Long>();

    public IdToEntityIterator(IndexHits<Long> ids) {
        super(ids);
        this.ids = ids;
    }

    protected boolean exceptionOk(Throwable t) {
        return t instanceof NotFoundException;
    }

    protected Long fetchNextOrNullFromSource(Iterator<Long> source) {
        while (source.hasNext()) {
            Long id = source.next();
            if (!this.alreadyReturned.add(id)) continue;
            return id;
        }
        return null;
    }

    public float currentScore() {
        return this.ids.currentScore();
    }

    public int size() {
        return this.ids.size();
    }

    public Iterator<T> iterator() {
        return this;
    }

    public void close() {
        this.ids.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getSingle() {
        try {
            PropertyContainer propertyContainer = (PropertyContainer)IteratorUtil.singleOrNull((Iterator)((Object)this));
            return (T)propertyContainer;
        }
        finally {
            this.close();
        }
    }
}

