/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

public class ValueContext {
    private final Object value;
    private boolean indexNumeric;

    public ValueContext(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public ValueContext indexNumeric() {
        if (!(this.value instanceof Number)) {
            throw new IllegalStateException("Value should be a Number, is " + this.value + " (" + this.value.getClass() + ")");
        }
        this.indexNumeric = true;
        return this;
    }

    public Object getCorrectValue() {
        return this.indexNumeric ? this.value : this.value.toString();
    }

    public String toString() {
        return this.value.toString();
    }

    public static ValueContext numeric(Number value) {
        return new ValueContext(value).indexNumeric();
    }
}

