/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.ClosureWriter;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationWriter {
    private static final MethodCallerMultiAdapter invokeMethodOnCurrent = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnCurrent", true, false);
    private static final MethodCallerMultiAdapter invokeMethodOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnSuper", true, false);
    private static final MethodCallerMultiAdapter invokeMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethod", true, false);
    private static final MethodCallerMultiAdapter invokeStaticMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeStaticMethod", true, true);
    private static final MethodCaller invokeClosureMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "invokeClosure");
    private WriterController controller;

    public InvocationWriter(WriterController wc) {
        this.controller = wc;
    }

    private void makeInvokeMethodCall(MethodCallExpression call, boolean useSuper, MethodCallerMultiAdapter adapter) {
        Expression objectExpression = call.getObjectExpression();
        CastExpression messageName = new CastExpression(ClassHelper.STRING_TYPE, call.getMethod());
        if (useSuper) {
            ClassNode classNode = this.controller.isInClosure() ? this.controller.getOutermostClass() : this.controller.getClassNode();
            ClassNode superClass = classNode.getSuperClass();
            this.makeCall(call, new ClassExpression(superClass), objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), false);
        } else {
            this.makeCall(call, objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), call.isImplicitThis());
        }
    }

    public void makeCall(Expression origin, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        ClassNode cn = this.controller.getClassNode();
        if (this.controller.isInClosure() && !implicitThis && AsmClassGenerator.isThisExpression(receiver)) {
            cn = cn.getOuterClass();
        }
        this.makeCall(origin, new ClassExpression(cn), receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
    }

    private boolean writeDirectMethodCall(MethodNode target, boolean implicitThis, Expression receiver, TupleExpression args) {
        if (target == null) {
            return false;
        }
        String methodName = target.getName();
        CompileStack compileStack = this.controller.getCompileStack();
        OperandStack operandStack = this.controller.getOperandStack();
        MethodVisitor mv = this.controller.getMethodVisitor();
        int opcode = 182;
        if (target.isStatic()) {
            opcode = 184;
        } else if (target.isPrivate()) {
            opcode = 183;
        }
        int argumentsToRemove = 0;
        if (opcode != 184) {
            if (receiver != null) {
                compileStack.pushImplicitThis(implicitThis);
                receiver.visit(this.controller.getAcg());
                operandStack.doGroovyCast(target.getDeclaringClass());
                compileStack.popImplicitThis();
                ++argumentsToRemove;
            } else {
                mv.visitIntInsn(25, 0);
            }
        }
        this.loadArguments(args.getExpressions(), target.getParameters());
        String owner = BytecodeHelper.getClassInternalName(target.getDeclaringClass());
        String desc = BytecodeHelper.getMethodDescriptor(target.getReturnType(), target.getParameters());
        mv.visitMethodInsn(opcode, owner, methodName, desc);
        ClassNode ret = target.getReturnType().redirect();
        if (ret == ClassHelper.VOID_TYPE) {
            ret = ClassHelper.OBJECT_TYPE;
            mv.visitInsn(1);
        }
        this.controller.getOperandStack().remove(argumentsToRemove += args.getExpressions().size());
        this.controller.getOperandStack().push(ret);
        return true;
    }

    private void loadArguments(List<Expression> argumentList, Parameter[] para) {
        for (int i = 0; i < argumentList.size(); ++i) {
            argumentList.get(i).visit(this.controller.getAcg());
            this.controller.getOperandStack().doGroovyCast(para[i].getType());
        }
    }

    private void makeCall(Expression origin, ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        int numberOfArguments;
        String methodName;
        MethodCallExpression mce;
        MethodNode target;
        boolean containsSpreadExpression;
        String methodName2;
        boolean fittingAdapter;
        boolean bl = fittingAdapter = adapter == invokeMethodOnCurrent || adapter == invokeStaticMethod;
        if (fittingAdapter && this.controller.optimizeForInt && this.controller.isFastPath() && (methodName2 = this.getMethodName(message)) != null) {
            TupleExpression args = arguments instanceof TupleExpression ? (TupleExpression)arguments : new TupleExpression(receiver);
            OptimizingStatementWriter.StatementMeta meta = null;
            if (origin != null) {
                meta = (OptimizingStatementWriter.StatementMeta)origin.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
            }
            MethodNode mn = null;
            if (meta != null) {
                mn = meta.target;
            }
            if (this.writeDirectMethodCall(mn, true, null, args)) {
                return;
            }
        }
        if (!(containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments)) && origin instanceof MethodCallExpression && this.writeDirectMethodCall(target = (mce = (MethodCallExpression)origin).getMethodTarget(), implicitThis, receiver, this.makeArgumentList(arguments))) {
            return;
        }
        if (!(adapter != invokeMethod && adapter != invokeMethodOnCurrent && adapter != invokeStaticMethod || spreadSafe || (methodName = this.getMethodName(message)) == null)) {
            this.controller.getCallSiteWriter().makeCallSite(receiver, methodName, arguments, safe, implicitThis, adapter == invokeMethodOnCurrent, adapter == invokeStaticMethod);
            return;
        }
        OperandStack operandStack = this.controller.getOperandStack();
        CompileStack compileStack = this.controller.getCompileStack();
        AsmClassGenerator acg = this.controller.getAcg();
        compileStack.pushLHS(false);
        if (adapter == AsmClassGenerator.setProperty) {
            ConstantExpression.NULL.visit(acg);
        } else {
            sender.visit(acg);
        }
        compileStack.pushImplicitThis(implicitThis);
        receiver.visit(acg);
        operandStack.box();
        compileStack.popImplicitThis();
        int operandsToRemove = 2;
        if (message != null) {
            message.visit(acg);
            operandStack.box();
            ++operandsToRemove;
        }
        int n = numberOfArguments = containsSpreadExpression ? -1 : AsmClassGenerator.argumentSize(arguments);
        if (numberOfArguments > 0 || containsSpreadExpression) {
            ArgumentListExpression ae = this.makeArgumentList(arguments);
            if (containsSpreadExpression) {
                acg.despreadList(ae.getExpressions(), true);
            } else {
                ae.visit(acg);
            }
        } else if (numberOfArguments > 0) {
            operandsToRemove += numberOfArguments;
            TupleExpression te = (TupleExpression)arguments;
            for (int i = 0; i < numberOfArguments; ++i) {
                Expression argument = te.getExpression(i);
                argument.visit(acg);
                operandStack.box();
                if (!(argument instanceof CastExpression)) continue;
                acg.loadWrapper(argument);
            }
        }
        adapter.call(this.controller.getMethodVisitor(), numberOfArguments, safe, spreadSafe);
        compileStack.popLHS();
        operandStack.replace(ClassHelper.OBJECT_TYPE, operandsToRemove);
    }

    private ArgumentListExpression makeArgumentList(Expression arguments) {
        ArgumentListExpression ae;
        if (arguments instanceof ArgumentListExpression) {
            ae = (ArgumentListExpression)arguments;
        } else if (arguments instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)arguments;
            ae = new ArgumentListExpression(te.getExpressions());
        } else {
            ae = new ArgumentListExpression();
            ae.addExpression(arguments);
        }
        return ae;
    }

    private String getMethodName(Expression message) {
        Expression methodExpr;
        CastExpression msg;
        String methodName = null;
        if (message instanceof CastExpression && (msg = (CastExpression)message).getType() == ClassHelper.STRING_TYPE && (methodExpr = msg.getExpression()) instanceof ConstantExpression) {
            methodName = methodExpr.getText();
        }
        if (methodName == null && message instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)message;
            methodName = constantExpression.getText();
        }
        return methodName;
    }

    public void writeInvokeMethod(MethodCallExpression call) {
        if (this.isClosureCall(call)) {
            this.invokeClosure(call.getArguments(), call.getMethodAsString());
        } else {
            boolean isSuperMethodCall = InvocationWriter.usesSuper(call);
            MethodCallerMultiAdapter adapter = invokeMethod;
            if (AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
                adapter = invokeMethodOnCurrent;
            }
            if (isSuperMethodCall) {
                adapter = invokeMethodOnSuper;
            }
            if (this.isStaticInvocation(call)) {
                adapter = invokeStaticMethod;
            }
            this.makeInvokeMethodCall(call, isSuperMethodCall, adapter);
        }
    }

    private boolean isClosureCall(MethodCallExpression call) {
        ClassNode classNode = this.controller.getClassNode();
        String methodName = call.getMethodAsString();
        if (methodName == null) {
            return false;
        }
        if (!call.isImplicitThis()) {
            return false;
        }
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        FieldNode field = classNode.getDeclaredField(methodName);
        if (field == null) {
            return false;
        }
        if (this.isStaticInvocation(call) && !field.isStatic()) {
            return false;
        }
        Expression arguments = call.getArguments();
        return !classNode.hasPossibleMethod(methodName, arguments);
    }

    private void invokeClosure(Expression arguments, String methodName) {
        AsmClassGenerator acg = this.controller.getAcg();
        acg.visitVariableExpression(new VariableExpression(methodName));
        if (arguments instanceof TupleExpression) {
            arguments.visit(acg);
        } else {
            new TupleExpression(arguments).visit(acg);
        }
        invokeClosureMethod.call(this.controller.getMethodVisitor());
        this.controller.getOperandStack().replace(ClassHelper.OBJECT_TYPE);
    }

    private boolean isStaticInvocation(MethodCallExpression call) {
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        if (this.controller.isStaticMethod()) {
            return true;
        }
        return this.controller.isStaticContext() && !call.isImplicitThis();
    }

    private static boolean usesSuper(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    public void writeInvokeStaticMethod(StaticMethodCallExpression call) {
        this.makeCall(call, new ClassExpression(call.getOwnerType()), new ConstantExpression(call.getMethod()), call.getArguments(), invokeStaticMethod, false, false, false);
    }

    private boolean writeDirectConstructorCall(ConstructorCallExpression call) {
        if (!this.controller.isFastPath()) {
            return false;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)call.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        ConstructorNode cn = null;
        if (meta != null) {
            cn = (ConstructorNode)meta.target;
        }
        if (cn == null) {
            return false;
        }
        String ownerDescriptor = this.prepareConstructorCall(cn);
        ArgumentListExpression args = this.makeArgumentList(call.getArguments());
        this.loadArguments(args.getExpressions(), cn.getParameters());
        this.finnishConstructorCall(cn, ownerDescriptor, args.getExpressions().size());
        return true;
    }

    private String prepareConstructorCall(ConstructorNode cn) {
        String owner = BytecodeHelper.getClassInternalName(cn.getDeclaringClass());
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitTypeInsn(187, owner);
        mv.visitInsn(89);
        return owner;
    }

    private void finnishConstructorCall(ConstructorNode cn, String ownerDescriptor, int argsToRemove) {
        String desc = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, cn.getParameters());
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(183, ownerDescriptor, "<init>", desc);
        this.controller.getOperandStack().remove(argsToRemove);
        this.controller.getOperandStack().push(cn.getDeclaringClass());
    }

    public void writeInvokeConstructor(ConstructorCallExpression call) {
        TupleExpression tupleExpression;
        int size;
        if (this.writeDirectConstructorCall(call)) {
            return;
        }
        if (this.writeAICCall(call)) {
            return;
        }
        Expression arguments = call.getArguments();
        if (arguments instanceof TupleExpression && (size = (tupleExpression = (TupleExpression)arguments).getExpressions().size()) == 0) {
            arguments = MethodCallExpression.NO_ARGUMENTS;
        }
        ClassExpression receiverClass = new ClassExpression(call.getType());
        this.controller.getCallSiteWriter().makeCallSite(receiverClass, "<$constructor$>", arguments, false, false, false, false);
    }

    private boolean writeAICCall(ConstructorCallExpression call) {
        if (!call.isUsingAnonymousInnerClass()) {
            return false;
        }
        ConstructorNode cn = call.getType().getDeclaredConstructors().get(0);
        OperandStack os = this.controller.getOperandStack();
        String ownerDescriptor = this.prepareConstructorCall(cn);
        List<Expression> args = this.makeArgumentList(call.getArguments()).getExpressions();
        Parameter[] params = cn.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Parameter p = params[i];
            Expression arg = args.get(i);
            if (arg instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)arg;
                this.loadVariableWithReference(var);
            } else {
                arg.visit(this.controller.getAcg());
            }
            os.doGroovyCast(p.getType());
        }
        this.finnishConstructorCall(cn, ownerDescriptor, args.size());
        return true;
    }

    private void loadVariableWithReference(VariableExpression var) {
        if (!var.isUseReferenceDirectly()) {
            var.visit(this.controller.getAcg());
        } else {
            ClosureWriter.loadReference(var.getName(), this.controller);
        }
    }
}

