/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.util;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import play.Logger;
import play.Play;
import play.modules.neo4j.annotation.Neo4jIndex;

public class Neo4jUtils {
    public static Class getClassNameFromNode(Node node) {
        if (node == null) {
            return null;
        }
        for (Relationship relation : node.getRelationships(Direction.INCOMING)) {
            Node startNode = relation.getStartNode();
            if (!startNode.hasProperty("KEY_COUNTER") || !startNode.hasProperty("CLASSNAME")) continue;
            String className = (String)startNode.getProperty("CLASSNAME");
            Logger.debug((String)("Node model class name is " + className), (Object[])new Object[0]);
            Class clazz = Play.classes.getApplicationClass((String)className).javaClass;
            return clazz;
        }
        return null;
    }

    public static boolean isIndexedField(Field field) {
        return field.getAnnotation(Neo4jIndex.class) != null;
    }

    public static String getIndexName(String className, Field field) {
        String indexName = null;
        Neo4jIndex nodeIndex = field.getAnnotation(Neo4jIndex.class);
        if (nodeIndex != null) {
            indexName = nodeIndex.value();
            if (indexName.equals("")) {
                indexName = field.getName();
            } else {
                return indexName;
            }
        }
        return Neo4jUtils.getIndexName(className, indexName);
    }

    public static String getIndexName(String className, String indexName) {
        indexName = className + "_" + indexName;
        indexName = indexName.toUpperCase();
        return indexName;
    }
}

