/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.Cd;
import org.neo4j.shell.kernel.apps.ReadOnlyGraphDatabaseApp;
import org.neo4j.shell.kernel.apps.TypedId;

public class Pwd
extends ReadOnlyGraphDatabaseApp {
    @Override
    public String getDescription() {
        return "Prints path to current node or relatioship";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String current = null;
        try {
            current = Pwd.getDisplayName(this.getServer(), session, this.getCurrent(session), false);
        }
        catch (ShellException e) {
            current = Pwd.getDisplayNameForNonExistent();
        }
        out.println((Serializable)((Object)("Current is " + current)));
        String path = this.stringifyPath(Cd.readCurrentWorkingDir(session), session) + current;
        if (path.length() > 0) {
            out.println((Serializable)((Object)path));
        }
        return null;
    }

    private String stringifyPath(List<TypedId> pathIds, Session session) throws ShellException {
        if (pathIds.isEmpty()) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (TypedId id : pathIds) {
            String displayName;
            try {
                displayName = Pwd.getDisplayName(this.getServer(), session, id, false);
            }
            catch (ShellException e) {
                displayName = Pwd.getDisplayNameForNonExistent();
            }
            path.append(displayName).append("-->");
        }
        return path.toString();
    }
}

