/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class DumpLogicalLog {
    public int dump(String filenameOrDirectory, TimeZone timeZone) throws IOException {
        int logsFound = 0;
        for (String fileName : DumpLogicalLog.filenamesOf(filenameOrDirectory, this.getLogPrefix())) {
            long prevLastCommittedTx;
            long logVersion;
            ++logsFound;
            System.out.println("=== " + fileName + " ===");
            FileChannel fileChannel = new RandomAccessFile(fileName, "r").getChannel();
            ByteBuffer buffer = ByteBuffer.allocateDirect(713);
            try {
                long[] header = LogIoUtils.readLogHeader(buffer, fileChannel, true);
                logVersion = header[0];
                prevLastCommittedTx = header[1];
            }
            catch (IOException ex) {
                System.out.println("Unable to read timestamp information, no records in logical log.");
                System.out.println(ex.getMessage());
                fileChannel.close();
                throw ex;
            }
            System.out.println("Logical log version: " + logVersion + " with prev committed tx[" + prevLastCommittedTx + "]");
            long logEntriesFound = 0L;
            XaCommandFactory cf = this.instantiateCommandFactory();
            while (this.readAndPrintEntry(fileChannel, buffer, cf, timeZone)) {
                ++logEntriesFound;
            }
            fileChannel.close();
        }
        return logsFound;
    }

    protected static boolean isAGraphDatabaseDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory() && new File(file, "neostore").exists();
    }

    protected boolean readAndPrintEntry(FileChannel fileChannel, ByteBuffer buffer, XaCommandFactory cf, TimeZone timeZone) throws IOException {
        LogEntry entry = LogIoUtils.readEntry(buffer, fileChannel, cf);
        if (entry != null) {
            System.out.println(entry.toString(timeZone));
            return true;
        }
        return false;
    }

    protected XaCommandFactory instantiateCommandFactory() {
        return new CommandFactory();
    }

    protected String getLogPrefix() {
        return "nioneo_logical.log";
    }

    public static void main(String[] args) throws IOException {
        Pair<Iterable<String>, TimeZone> config = DumpLogicalLog.parseConfig(args);
        for (String file : config.first()) {
            new DumpLogicalLog().dump(file, config.other());
        }
    }

    public static Pair<Iterable<String>, TimeZone> parseConfig(String[] args) {
        Args arguments = new Args(args);
        TimeZone timeZone = Format.DEFAULT_TIME_ZONE;
        String timeZoneString = arguments.get("timezone", null);
        if (timeZoneString != null) {
            timeZone = TimeZone.getTimeZone(timeZoneString);
        }
        return Pair.of(arguments.orphans(), timeZone);
    }

    protected static String[] filenamesOf(String filenameOrDirectory, final String prefix) {
        File file = new File(filenameOrDirectory);
        if (file.isDirectory()) {
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(prefix) && !name.contains("active");
                }
            });
            TreeSet<? super String> result = new TreeSet<String>(DumpLogicalLog.sequentialComparator());
            for (int i = 0; i < files.length; ++i) {
                result.add(files[i].getPath());
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[]{filenameOrDirectory};
    }

    private static Comparator<? super String> sequentialComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return this.versionOf(o1).compareTo(this.versionOf(o2));
            }

            private Integer versionOf(String string) {
                String toFind = ".v";
                int index = string.indexOf(toFind);
                if (index == -1) {
                    return Integer.MAX_VALUE;
                }
                return Integer.valueOf(string.substring(index + toFind.length()));
            }
        };
    }

    public static class CommandFactory
    extends XaCommandFactory {
        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, byteChannel, buffer);
        }
    }
}

