/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.branch;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class ExhaustMergePipe<S>
extends AbstractPipe<S, S>
implements MetaPipe {
    private final List<Pipe> pipes;
    int current = 0;
    final int total;

    public ExhaustMergePipe(List<Pipe> pipes) {
        this.pipes = pipes;
        this.total = pipes.size();
    }

    public ExhaustMergePipe(Pipe ... pipes) {
        this(Arrays.asList(pipes));
    }

    @Override
    public S processNextStart() {
        do {
            Pipe pipe;
            if ((pipe = this.pipes.get(this.current)).hasNext()) {
                return (S)pipe.next();
            }
            ++this.current;
        } while (this.current % this.total != 0);
        throw new NoSuchElementException();
    }

    @Override
    public void reset() {
        for (Pipe pipe : this.pipes) {
            pipe.reset();
        }
        super.reset();
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.pipes);
    }
}

