/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.event;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.event.listener.GraphChangedListener;
import java.util.List;
import java.util.Set;

public class EventElement
implements Element {
    protected final Element rawElement;
    protected final List<GraphChangedListener> graphChangedListeners;

    public EventElement(Element rawElement, List<GraphChangedListener> graphChangedListeners) {
        this.rawElement = rawElement;
        this.graphChangedListeners = graphChangedListeners;
    }

    protected void onVertexPropertyChanged(Vertex vertex, String key, Object newValue) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.vertexPropertyChanged(vertex, key, newValue);
        }
    }

    protected void onEdgePropertyChanged(Edge edge, String key, Object removedValue) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.edgePropertyChanged(edge, key, removedValue);
        }
    }

    protected void onVertexPropertyRemoved(Vertex vertex, String key, Object newValue) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.vertexPropertyRemoved(vertex, key, newValue);
        }
    }

    protected void onEdgePropertyRemoved(Edge edge, String key, Object removedValue) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.edgePropertyRemoved(edge, key, removedValue);
        }
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.rawElement.getPropertyKeys();
    }

    @Override
    public Object getId() {
        return this.rawElement.getId();
    }

    @Override
    public Object removeProperty(String key) {
        Object propertyRemoved = this.rawElement.removeProperty(key);
        if (this instanceof Vertex) {
            this.onVertexPropertyRemoved((Vertex)((Object)this), key, propertyRemoved);
        } else if (this instanceof Edge) {
            this.onEdgePropertyRemoved((Edge)((Object)this), key, propertyRemoved);
        }
        return propertyRemoved;
    }

    @Override
    public Object getProperty(String key) {
        return this.rawElement.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.rawElement.setProperty(key, value);
        if (this instanceof Vertex) {
            this.onVertexPropertyChanged((Vertex)((Object)this), key, value);
        } else if (this instanceof Edge) {
            this.onEdgePropertyChanged((Edge)((Object)this), key, value);
        }
    }

    public String toString() {
        return this.rawElement.toString();
    }

    public int hashCode() {
        return this.rawElement.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && object.getClass().equals(this.getClass()) && this.rawElement.getId().equals(((EventElement)object).getId());
    }

    public Element getRawElement() {
        return this.rawElement;
    }
}

