/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.shell.Console;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.impl.JLineConsole;
import org.neo4j.shell.impl.SessionImpl;
import org.neo4j.shell.impl.StandardConsole;

public abstract class AbstractClient
implements ShellClient {
    public static final String PROMPT_KEY = "PS1";
    public static final String STACKTRACES_KEY = "STACKTRACES";
    public static final String TITLE_KEYS_KEY = "TITLE_KEYS";
    public static final String TITLE_MAX_LENGTH = "TITLE_MAX_LENGTH";
    private static final Set<String> EXIT_COMMANDS = new HashSet<String>(Arrays.asList("exit", "quit"));
    private Console console;
    private long timeConnection;
    private final Set<String> grabbedKeysFromServer = new HashSet<String>();
    private final SessionImpl session = new SessionImpl();
    private volatile boolean end;
    private final Collection<String> multiLine = new ArrayList<String>();

    @Override
    public void grabPrompt() {
        this.init();
        while (!this.end) {
            try {
                this.evaluate(this.readLine(this.getPrompt()));
            }
            catch (Exception e) {
                if (this.shouldPrintStackTraces()) {
                    e.printStackTrace();
                    continue;
                }
                this.console.format(AbstractClient.getShortExceptionMessage(e) + "\n", new Object[0]);
            }
        }
        this.shutdown();
    }

    @Override
    public void evaluate(String line) throws ShellException {
        if (EXIT_COMMANDS.contains(line)) {
            this.end();
            return;
        }
        boolean success = false;
        try {
            String expandedLine = this.expandLine(this.fullLine(line));
            String result = this.getServer().interpretLine(expandedLine, this.session(), this.getOutput());
            if (result == null || result.trim().length() == 0) {
                this.endMultiLine();
            } else if (result.contains("c")) {
                this.multiLine.add(line);
            } else if (result.contains("e")) {
                this.end();
            }
            success = true;
        }
        catch (RemoteException e) {
            throw ShellException.wrapCause(e);
        }
        finally {
            if (!success) {
                this.endMultiLine();
            }
        }
    }

    private void endMultiLine() {
        this.multiLine.clear();
    }

    private String fullLine(String line) {
        if (this.multiLine.isEmpty()) {
            return line;
        }
        StringBuilder result = new StringBuilder();
        for (String oneLine : this.multiLine) {
            result.append(result.length() > 0 ? "\n" : "").append(oneLine);
        }
        return result.append("\n" + line).toString();
    }

    @Override
    public void end() {
        this.end = true;
    }

    private String expandLine(String line) throws RemoteException {
        return TextUtil.templateString(line, this.session().asMap());
    }

    protected static String getShortExceptionMessage(Exception e) {
        return e.getMessage();
    }

    @Override
    public String getPrompt() {
        if (!this.multiLine.isEmpty()) {
            return "> ";
        }
        String result = null;
        try {
            result = (String)((Object)this.getSessionVariable(PROMPT_KEY, null, true));
        }
        catch (Exception e) {
            try {
                result = (String)((Object)this.getSessionVariable(PROMPT_KEY, null, false));
            }
            catch (ShellException e1) {
                throw new RuntimeException(e1);
            }
        }
        return result;
    }

    public boolean shouldPrintStackTraces() {
        Serializable value = this.session().get(STACKTRACES_KEY);
        return this.getSafeBooleanValue(value, false);
    }

    private boolean getSafeBooleanValue(Object value, boolean def) {
        return value == null ? def : Boolean.parseBoolean(value.toString());
    }

    protected void init() {
        try {
            ShellServer server = this.getServer();
            this.possiblyGrabDefaultVariableFromServer(server, PROMPT_KEY, (Serializable)((Object)"$ "));
            this.possiblyGrabDefaultVariableFromServer(server, TITLE_KEYS_KEY, null);
            this.possiblyGrabDefaultVariableFromServer(server, TITLE_MAX_LENGTH, null);
            this.getOutput().println((Serializable)((Object)server.welcome()));
            this.console = JLineConsole.newConsoleOrNullIfNotFound(this);
            if (this.console == null) {
                System.out.println("Want bash-like features? throw in jLine (http://jline.sourceforge.net) on the classpath");
                this.console = new StandardConsole();
            }
            this.getOutput().println();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void possiblyGrabDefaultVariableFromServer(ShellServer server, String key, Serializable defaultValue) {
        try {
            if (this.session().get(key) == null) {
                this.grabbedKeysFromServer.add(key);
                Serializable value = server.getProperty(key);
                if (value == null) {
                    value = defaultValue;
                }
                if (value != null) {
                    this.session().set(key, value);
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void regrabVariablesFromServer(ShellServer server) {
        for (String key : this.grabbedKeysFromServer) {
            Serializable value = this.session().remove(key);
            this.possiblyGrabDefaultVariableFromServer(server, key, value);
        }
    }

    protected Serializable getSessionVariable(String key, Serializable defaultValue, boolean interpret) throws ShellException {
        try {
            Serializable result = this.session().get(key);
            if (result == null) {
                result = defaultValue;
            }
            if (interpret && result != null) {
                result = this.getServer().interpretVariable(key, result, this.session());
            }
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readLine(String prompt) {
        return this.console.readLine(prompt);
    }

    static String[] getExitCommands() {
        return EXIT_COMMANDS.toArray(new String[EXIT_COMMANDS.size()]);
    }

    protected void updateTimeForMostRecentConnection() {
        this.timeConnection = System.currentTimeMillis();
    }

    @Override
    public long timeForMostRecentConnection() {
        return this.timeConnection;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public void shutdown() {
        if (this.session.writer != null) {
            this.tryUnexport(this.session.writer);
        }
    }

    protected void tryUnexport(Remote remote) {
        try {
            UnicastRemoteObject.unexportObject(remote, true);
        }
        catch (NoSuchObjectException e) {
            System.out.println("Couldn't unexport:" + remote);
        }
    }
}

