/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.RemoteOutput;
import org.neo4j.shell.impl.RmiLocation;

public class RemoteClient
extends AbstractClient {
    private ShellServer server;
    private RmiLocation serverLocation;
    private Output out;

    public RemoteClient(RmiLocation serverLocation) throws ShellException {
        this(serverLocation, RemoteOutput.newOutput());
    }

    public RemoteClient(RmiLocation serverLocation, Output out) throws ShellException {
        this.serverLocation = serverLocation;
        this.server = this.findRemoteServer();
        this.out = out;
    }

    private ShellServer findRemoteServer() throws ShellException {
        try {
            ShellServer result = (ShellServer)this.serverLocation.getBoundObject();
            this.updateTimeForMostRecentConnection();
            return result;
        }
        catch (RemoteException e) {
            throw ShellException.wrapCause(e);
        }
    }

    @Override
    public Output getOutput() {
        return this.out;
    }

    @Override
    public ShellServer getServer() {
        boolean shouldTryToReconnect = this.server == null;
        try {
            if (!shouldTryToReconnect) {
                this.server.welcome();
            }
        }
        catch (RemoteException e) {
            shouldTryToReconnect = true;
        }
        Exception originException = null;
        if (shouldTryToReconnect) {
            this.server = null;
            try {
                this.server = this.findRemoteServer();
                this.getOutput().println((Serializable)((Object)"[Reconnected to server]"));
                this.regrabVariablesFromServer(this.server);
            }
            catch (ShellException ee) {
                originException = ee;
            }
            catch (RemoteException ee) {
                originException = ee;
            }
        }
        if (this.server == null) {
            throw new RuntimeException("Server closed or cannot be reached anymore: " + originException.getMessage(), originException);
        }
        return this.server;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tryUnexport(this.out);
    }
}

