/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelData;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ShellBootstrap
implements Serializable {
    private final Map<String, Serializable> config;
    private final boolean enable;

    ShellBootstrap(KernelData kernel) {
        String shellConfig = (String)kernel.getParam("enable_remote_shell");
        Map<String, Serializable> config = null;
        boolean enable = false;
        if (shellConfig != null) {
            if (Config.configValueContainsMultipleParameters(shellConfig)) {
                enable = true;
                config = ShellBootstrap.parseShellConfigParameter(shellConfig);
            } else if (Boolean.parseBoolean(shellConfig)) {
                enable = true;
            }
        }
        this.enable = enable;
        this.config = config;
    }

    public ShellBootstrap(Map<String, Serializable> config) {
        this.config = config;
        this.enable = true;
    }

    public ShellBootstrap(String port, String name) {
        this.enable = true;
        this.config = new HashMap<String, Serializable>();
        this.config.put("port", Integer.valueOf(port != null ? Integer.parseInt(port) : 1337));
        this.config.put("name", (Serializable)((Object)name));
    }

    private static Map<String, Serializable> parseShellConfigParameter(String shellConfig) {
        Args parsed = Config.parseMapFromConfigValue("enable_remote_shell", shellConfig);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("port", Integer.valueOf(parsed.getNumber("port", 1337).intValue()));
        map.put("readonly", parsed.getBoolean("readonly", false, true));
        return map;
    }

    public String serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return new BASE64Encoder().encode(os.toByteArray());
    }

    static String serializeStub(Remote obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(RemoteObject.toStub(obj));
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return new BASE64Encoder().encode(os.toByteArray());
    }

    static ShellBootstrap deserialize(String data) {
        try {
            return (ShellBootstrap)new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(data))).readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    GraphDatabaseShellServer load(GraphDatabaseService graphDb) throws RemoteException {
        if (!this.enable) {
            return null;
        }
        return this.enable(new GraphDatabaseShellServer(graphDb, (Boolean)this.getConfig("readonly", Boolean.FALSE)));
    }

    void visit(GraphDatabaseShellServer state) {
    }

    private Serializable getConfig(String key, Serializable defaultValue) {
        Serializable result = this.config != null ? this.config.get(key) : null;
        return result != null ? result : defaultValue;
    }

    public GraphDatabaseShellServer enable(GraphDatabaseShellServer server) throws RemoteException {
        Integer port = (Integer)this.getConfig("port", Integer.valueOf(1337));
        String name = (String)((Object)this.getConfig("name", (Serializable)((Object)"shell")));
        server.makeRemotelyAvailable(port, name);
        return server;
    }
}

