/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class GraphDatabaseTestAccess
extends AbstractGraphDatabase {
    private final EmbeddedGraphDbImpl impl;
    protected final FileSystemAbstraction fileSystem;

    public GraphDatabaseTestAccess(String storeDir, Map<String, String> config, IdGeneratorFactory idGenerators, FileSystemAbstraction fileSystem) {
        super(storeDir);
        config = config != null ? config : MapUtil.stringMap((String[])new String[0]);
        this.impl = new EmbeddedGraphDbImpl(this.getStoreDir(), null, config, (AbstractGraphDatabase)this, CommonFactories.defaultLockManagerFactory(), idGenerators, CommonFactories.defaultRelationshipTypeCreator(), CommonFactories.defaultTxIdGeneratorFactory(), CommonFactories.defaultTxHook(), CommonFactories.defaultLastCommittedTxIdSetter(), fileSystem);
        this.fileSystem = fileSystem;
    }

    public Node createNode() {
        return this.impl.createNode();
    }

    public Node getNodeById(long id) {
        return this.impl.getNodeById(id);
    }

    public Relationship getRelationshipById(long id) {
        return this.impl.getRelationshipById(id);
    }

    public Node getReferenceNode() {
        return this.impl.getReferenceNode();
    }

    protected void close() {
        this.impl.shutdown();
    }

    public TransactionBuilder tx() {
        return this.impl.tx();
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.impl.registerTransactionEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.impl.unregisterTransactionEventHandler(handler);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.impl.registerKernelEventHandler(handler);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.impl.unregisterKernelEventHandler(handler);
    }

    public IndexManager index() {
        return this.impl.index();
    }

    public Config getConfig() {
        return this.impl.getConfig();
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.impl.getManagementBeans(type);
    }

    public KernelData getKernelData() {
        return this.impl.getKernelData();
    }
}

