/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DummyExtension;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtensionContractTest;
import org.neo4j.kernel.OtherExtension;

public final class TestKernelExtension
extends KernelExtensionContractTest<DummyExtension.State, DummyExtension> {
    public TestKernelExtension() {
        super("dummy", DummyExtension.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canDisableLoadingKernelExtensions() throws Exception {
        EmbeddedGraphDatabase graphdb = this.graphdb("graphdb", false, 0);
        try {
            Assert.assertFalse((String)"Extensions were loaded despite configured not to", (boolean)new DummyExtension().isLoaded(TestKernelExtension.getExtensions(graphdb)));
        }
        finally {
            graphdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRetrieveSameLoadedStateObjectWhenRequested() throws Exception {
        EmbeddedGraphDatabase graphdb = this.graphdb("graphdb", true, 0);
        try {
            DummyExtension.State state = (DummyExtension.State)new DummyExtension().getState(TestKernelExtension.getExtensions(graphdb));
            Assert.assertNotNull((Object)state);
            Assert.assertSame((Object)DummyExtension.lastState, (Object)state);
        }
        finally {
            graphdb.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void differentExtensionsCanHaveDifferentState() throws Exception {
        EmbeddedGraphDatabase graphdb = this.graphdb("graphdb", true, 0);
        try {
            KernelData kernel = TestKernelExtension.getExtensions(graphdb);
            DummyExtension.State state = (DummyExtension.State)new DummyExtension().getState(kernel);
            DummyExtension.State other = (DummyExtension.State)new OtherExtension().getState(kernel);
            Assert.assertNotNull((Object)state);
            Assert.assertNotNull((Object)other);
            Assert.assertNotSame((Object)state, (Object)other);
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Override
    protected boolean isUnloaded(DummyExtension.State state) {
        return state.unloaded;
    }
}

