/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestNode
extends AbstractNeo4jTestCase {
    @Test
    public void testNodeCreateAndDelete() {
        long nodeId = -1L;
        Node node = this.getGraphDb().createNode();
        nodeId = node.getId();
        this.getGraphDb().getNodeById(nodeId);
        node.delete();
        Transaction tx = this.getTransaction();
        tx.success();
        tx.finish();
        this.setTransaction(this.getGraphDb().beginTx());
        try {
            this.getGraphDb().getNodeById(nodeId);
            Assert.fail((String)("Node[" + nodeId + "] should be deleted."));
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testDeletedNode() {
        Node node = this.getGraphDb().createNode();
        node.delete();
        Logger log = Logger.getLogger("org.neo4j.kernel.impl.core.NeoConstraintsListener");
        Level level = log.getLevel();
        log.setLevel(Level.OFF);
        try {
            node.setProperty("key1", (Object)new Integer(1));
            Assert.fail((String)"Adding stuff to deleted node should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        log.setLevel(level);
    }

    @Test
    public void testNodeAddProperty() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        try {
            node1.setProperty(null, null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        Assert.assertTrue((boolean)node1.hasProperty(key1));
        Assert.assertTrue((boolean)node2.hasProperty(key1));
        Assert.assertTrue((boolean)node1.hasProperty(key2));
        Assert.assertTrue((boolean)node2.hasProperty(key2));
        Assert.assertTrue((!node1.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertTrue((!node2.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)int1, (Object)node1.getProperty(key1));
        Assert.assertEquals((Object)string1, (Object)node2.getProperty(key1));
        Assert.assertEquals((Object)string2, (Object)node1.getProperty(key2));
        Assert.assertEquals((Object)int2, (Object)node2.getProperty(key2));
        this.getTransaction().failure();
    }

    @Test
    public void testNodeRemoveProperty() {
        String key1 = "key1";
        String key2 = "key2";
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        try {
            if (node1.removeProperty(key1) != null) {
                Assert.fail((String)"Remove of non existing property should return null");
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            node1.removeProperty(null);
            Assert.fail((String)"Remove null property should throw exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        try {
            node1.removeProperty(null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)int1, (Object)node1.removeProperty(key1));
        Assert.assertEquals((Object)string1, (Object)node2.removeProperty(key1));
        try {
            if (node2.removeProperty(key1) != null) {
                Assert.fail((String)"Remove of non existing property return null.");
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        this.getTransaction().failure();
    }

    @Test
    public void testNodeChangeProperty() {
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Boolean bool1 = new Boolean(true);
        Boolean bool2 = new Boolean(false);
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        try {
            node1.setProperty(null, null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (NotFoundException e) {
            Assert.fail((String)"wrong exception");
        }
        node1.setProperty(key1, (Object)int2);
        node2.setProperty(key1, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)node2.getProperty(key1));
        node1.setProperty(key3, (Object)bool1);
        node1.setProperty(key3, (Object)bool2);
        Assert.assertEquals((Object)string2, (Object)node2.getProperty(key1));
        node1.delete();
        node2.delete();
    }

    @Test
    public void testNodeChangeProperty2() {
        String key1 = "key1";
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string1 = new String("1");
        String string2 = new String("2");
        Boolean bool1 = new Boolean(true);
        Boolean bool2 = new Boolean(false);
        Node node1 = this.getGraphDb().createNode();
        node1.setProperty(key1, (Object)int1);
        node1.setProperty(key1, (Object)int2);
        Assert.assertEquals((Object)int2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.setProperty(key1, (Object)string1);
        node1.setProperty(key1, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.setProperty(key1, (Object)bool1);
        node1.setProperty(key1, (Object)bool2);
        Assert.assertEquals((Object)bool2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.delete();
    }

    @Test
    public void testNodeGetProperties() {
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        String string = new String("3");
        Node node1 = this.getGraphDb().createNode();
        Assert.assertTrue((!node1.getPropertyValues().iterator().hasNext() ? 1 : 0) != 0);
        try {
            node1.getProperty(key1);
            Assert.fail((String)"get non existing property din't throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            node1.getProperty(null);
            Assert.fail((String)"get of null key din't throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertTrue((!node1.hasProperty(key1) ? 1 : 0) != 0);
        Assert.assertTrue((!node1.hasProperty(null) ? 1 : 0) != 0);
        node1.setProperty(key1, (Object)int1);
        node1.setProperty(key2, (Object)int2);
        node1.setProperty(key3, (Object)string);
        Iterator values = node1.getPropertyValues().iterator();
        values.next();
        values.next();
        values.next();
        Iterator keys = node1.getPropertyKeys().iterator();
        keys.next();
        keys.next();
        keys.next();
        Assert.assertTrue((boolean)node1.hasProperty(key1));
        Assert.assertTrue((boolean)node1.hasProperty(key2));
        Assert.assertTrue((boolean)node1.hasProperty(key3));
        try {
            node1.removeProperty(key3);
        }
        catch (NotFoundException e) {
            Assert.fail((String)"Remove of property failed.");
        }
        Assert.assertTrue((!node1.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertTrue((!node1.hasProperty(null) ? 1 : 0) != 0);
        node1.delete();
    }

    @Test
    public void testAddPropertyThenDelete() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test");
        Transaction tx = this.getTransaction();
        tx.success();
        tx.finish();
        tx = this.getGraphDb().beginTx();
        node.setProperty("test2", (Object)"test2");
        node.delete();
        tx.success();
        tx.finish();
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testChangeProperty() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test1");
        this.newTransaction();
        node.setProperty("test", (Object)"test2");
        node.removeProperty("test");
        node.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        node.removeProperty("test");
        node.setProperty("test", (Object)"test4");
        this.newTransaction();
        Assert.assertEquals((Object)"test4", (Object)node.getProperty("test"));
    }

    @Test
    public void testChangeProperty2() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test1");
        this.newTransaction();
        node.removeProperty("test");
        node.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        this.newTransaction();
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        node.removeProperty("test");
        node.setProperty("test", (Object)"test4");
        this.newTransaction();
        Assert.assertEquals((Object)"test4", (Object)node.getProperty("test"));
    }

    @Test
    public void testNodeLockingProblem() throws InterruptedException {
        this.testLockProblem((PropertyContainer)this.getGraphDb().createNode());
    }

    @Test
    public void testRelationshipLockingProblem() throws InterruptedException {
        Node node = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        this.testLockProblem((PropertyContainer)node.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"lock-rel")));
    }

    private void testLockProblem(final PropertyContainer entity) throws InterruptedException {
        entity.setProperty("key", (Object)"value");
        final AtomicBoolean gotTheLock = new AtomicBoolean();
        Thread thread = new Thread(){

            @Override
            public void run() {
                Transaction tx = TestNode.this.getGraphDb().beginTx();
                try {
                    ((AbstractGraphDatabase)TestNode.this.getGraphDb()).getConfig().getLockManager().getWriteLock((Object)entity);
                    gotTheLock.set(true);
                    tx.success();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    tx.failure();
                }
            }
        };
        thread.start();
        long endTime = System.currentTimeMillis() + 5000L;
        block0: while (thread.getState() != Thread.State.TERMINATED) {
            if (thread.getState() == Thread.State.WAITING) {
                for (StackTraceElement el : thread.getStackTrace()) {
                    if (el.getClassName().equals("org.neo4j.kernel.impl.transaction.RWLock") && el.getMethodName().equals("acquireWriteLock")) break block0;
                }
            }
            Thread.sleep(1L);
            if (System.currentTimeMillis() <= endTime) continue;
        }
        boolean gotLock = gotTheLock.get();
        this.newTransaction();
        Assert.assertFalse((boolean)gotLock);
        thread.join();
    }
}

