/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.subprocess.BeforeDebuggedTest;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.core.ArrayBasedPrimitive", method="setProperties"), @ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.core.ArrayBasedPrimitive", method="commitPropertyMaps", on=BreakPoint.Event.EXIT)})
@RunWith(value=SubProcessTestRunner.class)
public class TestPropertyCachePoisoning {
    private static DebuggedThread readerThread;
    private static DebuggedThread removerThread;
    private AbstractGraphDatabase graphdb;

    @Test
    @EnabledBreakpoints(value={"setProperties", "removeProperty"})
    public void raceBetweenPropertyReaderAndPropertyWriter() {
        final Node first = (Node)new TX<Node>(){

            @Override
            Node perform() {
                Node node = TestPropertyCachePoisoning.this.graphdb.createNode();
                node.setProperty("key", (Object)"value");
                return node;
            }
        }.result();
        this.clearCache();
        new TxThread(){

            @Override
            void perform() {
                TestPropertyCachePoisoning.this.removeProperty(first, "key");
            }
        };
        System.out.println("key:" + first.getProperty("key", null));
        Node second = (Node)new TX<Node>(){

            @Override
            Node perform() {
                Node node = TestPropertyCachePoisoning.this.graphdb.createNode();
                node.setProperty("key", (Object)"other");
                return node;
            }
        }.result();
        new TX<Void>(){

            @Override
            Void perform() {
                first.removeProperty("key");
                return null;
            }
        };
        this.clearCache();
        Assert.assertEquals((Object)"other", (Object)second.getProperty("key"));
    }

    @BeforeDebuggedTest
    public static void resetThreadReferences() {
        removerThread = null;
        readerThread = null;
    }

    @BreakpointTrigger
    void removeProperty(Node node, String key) {
        node.removeProperty(key);
    }

    @BreakpointHandler(value={"removeProperty"})
    public static void handleRemoveProperty(@BreakpointHandler(value={"commitPropertyMaps"}) BreakPoint exitCommit, DebugInterface di) {
        if (readerThread == null) {
            removerThread = di.thread().suspend(null);
        }
        exitCommit.enable();
    }

    @BreakpointHandler(value={"setProperties"})
    public static void handleSetProperties(BreakPoint self, DebugInterface di) {
        self.disable();
        if (removerThread != null) {
            removerThread.resume();
            removerThread = null;
        }
        readerThread = di.thread().suspend(DebuggerDeadlockCallback.RESUME_THREAD);
    }

    @BreakpointHandler(value={"commitPropertyMaps"})
    public static void exitCommitPropertyMaps(BreakPoint self, DebugInterface di) {
        self.disable();
        readerThread.resume();
        readerThread = null;
    }

    private void clearCache() {
        this.graphdb.getConfig().getGraphDbModule().getNodeManager().clearCache();
    }

    @Before
    public void startGraphdb() {
        this.graphdb = new ImpermanentGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void stopGraphdb() {
        try {
            if (this.graphdb != null) {
                this.graphdb.shutdown();
            }
        }
        finally {
            this.graphdb = null;
        }
    }

    private abstract class TX<T> {
        private final T value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TX() {
            Transaction tx = TestPropertyCachePoisoning.this.graphdb.beginTx();
            try {
                this.value = this.perform();
                tx.success();
            }
            finally {
                tx.finish();
            }
        }

        abstract T perform();

        final T result() {
            return this.value;
        }
    }

    private abstract class TxThread {
        public TxThread() {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Transaction tx = TestPropertyCachePoisoning.this.graphdb.beginTx();
                    try {
                        TxThread.this.perform();
                        tx.success();
                    }
                    finally {
                        tx.finish();
                    }
                }
            }.start();
        }

        abstract void perform();
    }
}

