/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.impl.index.IndexProviderStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class TestIndexProviderStore {
    private File file;
    private FileSystemAbstraction fileSystem;

    @Before
    public void createStore() {
        this.file = new File("target/test-data/index-provider-store");
        this.fileSystem = CommonFactories.defaultFileSystemAbstraction();
        this.file.mkdirs();
        this.file.delete();
    }

    @Test
    public void lastCommitedTxGetsStoredBetweenSessions() throws Exception {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        store.setVersion(5L);
        store.setLastCommittedTx(12L);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        Assert.assertEquals((long)5L, (long)store.getVersion());
        Assert.assertEquals((long)12L, (long)store.getLastCommittedTx());
        store.close();
    }

    @Test
    public void shouldFailUpgradeIfNotAllowed() {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), true);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), false);
        store.close();
        try {
            new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), false);
            Assert.fail((String)"Shouldn't be able to upgrade there");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), true);
        Assert.assertEquals((Object)"3.5", (Object)NeoStore.versionLongToString((long)store.getIndexVersion()));
        store.close();
    }
}

