/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.matchers.StringContains;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.util.FileUtils;

public class StoreVersionTest {
    @Test
    public void allStoresShouldHaveTheCurrentVersionIdentifier() throws IOException {
        CommonAbstractStore[] stores;
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName());
        FileUtils.deleteRecursively((File)outputDir);
        Assert.assertTrue((boolean)outputDir.mkdirs());
        String storeFileName = new File(outputDir, "neostore").getPath();
        HashMap<Object, Object> config = new HashMap<Object, Object>();
        config.put(IdGeneratorFactory.class, CommonFactories.defaultIdGeneratorFactory());
        config.put(FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction());
        config.put("neo_store", storeFileName);
        NeoStore.createStore((String)storeFileName, config);
        NeoStore neoStore = new NeoStore(config);
        for (CommonAbstractStore store : stores = new CommonAbstractStore[]{neoStore.getNodeStore(), neoStore.getRelationshipStore(), neoStore.getRelationshipTypeStore(), neoStore.getPropertyStore(), neoStore.getPropertyStore().getIndexStore()}) {
            Assert.assertThat((Object)store.getTypeAndVersionDescriptor(), (Matcher)StringContains.containsString((String)"v0.A.0"));
        }
        neoStore.close();
    }

    @Test
    @Ignore
    public void shouldFailToCreateAStoreContainingOldVersionNumber() throws IOException {
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName());
        FileUtils.deleteRecursively((File)outputDir);
        Assert.assertTrue((boolean)outputDir.mkdirs());
        URL legacyStoreResource = StoreMigrator.class.getResource("legacystore/exampledb/neostore.nodestore.db");
        File workingFile = new File(outputDir, "neostore.nodestore.db");
        FileUtils.copyFile((File)new File(legacyStoreResource.getFile()), (File)workingFile);
        HashMap<Class, Object> config = new HashMap<Class, Object>();
        config.put(IdGeneratorFactory.class, CommonFactories.defaultIdGeneratorFactory());
        config.put(FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction());
        try {
            new NodeStore(workingFile.getPath(), config);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NotCurrentStoreVersionException e) {
            // empty catch block
        }
    }

    @Test
    public void neoStoreHasCorrectStoreVersionField() throws IOException {
        File outputDir = new File("target/var/" + StoreVersionTest.class.getSimpleName() + "test2");
        FileUtils.deleteRecursively((File)outputDir);
        Assert.assertTrue((boolean)outputDir.mkdirs());
        String storeFileName = new File(outputDir, "neostore").getPath();
        HashMap<Object, Object> config = new HashMap<Object, Object>();
        config.put(IdGeneratorFactory.class, CommonFactories.defaultIdGeneratorFactory());
        config.put(FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction());
        config.put("neo_store", storeFileName);
        NeoStore.createStore((String)storeFileName, config);
        NeoStore neoStore = new NeoStore(config);
        Assert.assertEquals((Object)"v0.A.0", (Object)NeoStore.versionLongToString((long)neoStore.getStoreVersion()));
        Assert.assertEquals((Object)"v0.A.0", (Object)NeoStore.versionLongToString((long)NeoStore.getStoreVersion((String)storeFileName)));
    }

    @Test
    public void testProperEncodingDecodingOfVersionString() {
        String[] toTest;
        for (String string : toTest = new String[]{"123", "foo", "0.9.9", "v0.A.0", "bar", "chris", "1234567"}) {
            Assert.assertEquals((Object)string, (Object)NeoStore.versionLongToString((long)NeoStore.versionStringToLong((String)string)));
        }
    }
}

