/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.nioneo.store.StoreFailureException;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestIdGenerator {
    @Before
    public void deleteIdGeneratorFile() {
        new File(this.idGeneratorFile()).delete();
    }

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("xatest");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String idGeneratorFile() {
        return this.file("testIdGenerator.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateIdGenerator() throws IOException {
        try {
            IdGeneratorImpl.createGenerator(null);
            Assert.fail((String)"Null filename should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            new IdGeneratorImpl(this.idGeneratorFile(), 0, 100L, false).close(true);
            Assert.fail((String)"Zero grab size should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new IdGeneratorImpl("testIdGenerator.id", -1, 100L, false).close(true);
            Assert.fail((String)"Negative grab size should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1008, 1000L, false);
            try {
                IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
                Assert.fail((String)"Creating a id generator with existing file name should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            FileChannel fileChannel = new FileInputStream(this.idGeneratorFile()).getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(9);
            Assert.assertEquals((long)9L, (long)fileChannel.read(buffer));
            buffer.flip();
            Assert.assertEquals((long)0L, (long)buffer.get());
            Assert.assertEquals((long)0L, (long)buffer.getLong());
            buffer.flip();
            int readCount = fileChannel.read(buffer);
            if (readCount != -1 && readCount != 0) {
                Assert.fail((String)("Id generator header not ok read 9 + " + readCount + " bytes from file"));
            }
            fileChannel.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    private void closeIdGenerator(IdGenerator idGenerator) {
        idGenerator.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyGenerator() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGen = new IdGeneratorImpl(this.idGeneratorFile(), 3, 1000L, false);
            try {
                new IdGeneratorImpl(this.idGeneratorFile(), 3, 1000L, false);
                Assert.fail((String)"Opening sticky id generator should throw exception");
            }
            catch (StoreFailureException storeFailureException) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGen);
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNextId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3, 1000L, false);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            idGenerator.freeId(1L);
            idGenerator.freeId(3L);
            idGenerator.freeId(5L);
            Assert.assertEquals((long)7L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 5, 1000L, false);
            idGenerator.freeId(2L);
            idGenerator.freeId(4L);
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            idGenerator.freeId(1L);
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            idGenerator.freeId(3L);
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            idGenerator.freeId(5L);
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            idGenerator.freeId(8L);
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            idGenerator.freeId(9L);
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3, 1000L, false);
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            Assert.assertEquals((long)10L, (long)idGenerator.nextId());
            Assert.assertEquals((long)11L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFreeId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3, 1000L, false);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            try {
                idGenerator.freeId(-1L);
                Assert.fail((String)"Negative id should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(7L);
                Assert.fail((String)"Greater id than ever returned should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            for (int i = 0; i < 7; ++i) {
                idGenerator.freeId((long)i);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2, 1000L, false);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2, 1000L, false);
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2, 1000L, false);
            this.closeIdGenerator((IdGenerator)idGenerator);
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2, 1000L, false);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOddAndEvenWorstCase() {
        File file;
        long i;
        IdGeneratorImpl idGenerator;
        int capacity = 8193;
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 128, (long)(capacity * 2), false);
            for (int i2 = 0; i2 < capacity; ++i2) {
                idGenerator.nextId();
            }
            HashMap<Long, TestIdGenerator> freedIds = new HashMap<Long, TestIdGenerator>();
            for (i = 1L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2000, (long)(capacity * 2), false);
            long oldId = -1L;
            for (int i3 = 0; i3 < capacity - 1; i3 += 2) {
                long id = idGenerator.nextId();
                if (freedIds.remove(id) == null) {
                    throw new RuntimeException("Id=" + id + " prevId=" + oldId + " list.size()=" + freedIds.size());
                }
                oldId = id;
            }
            Assert.assertTrue((freedIds.values().size() == 0 ? 1 : 0) != 0);
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 128, (long)(capacity * 2), false);
            for (int i4 = 0; i4 < capacity; ++i4) {
                idGenerator.nextId();
            }
            HashMap<Long, TestIdGenerator> freedIds = new HashMap<Long, TestIdGenerator>();
            for (i = 0L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2000, (long)(capacity * 2), false);
            for (int i5 = 0; i5 < capacity; i5 += 2) {
                Assert.assertEquals((Object)this, freedIds.remove(idGenerator.nextId()));
            }
            Assert.assertEquals((long)0L, (long)freedIds.values().size());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        int numberOfCloses = 0;
        Random random = new Random(System.currentTimeMillis());
        int capacity = random.nextInt(1024) + 1024;
        int grabSize = random.nextInt(128) + 128;
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), grabSize, (long)(capacity * 2), false);
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        float releaseIndex = 0.25f;
        float closeIndex = 0.05f;
        int currentIdCount = 0;
        try {
            while (currentIdCount < capacity) {
                float rIndex = random.nextFloat();
                if (rIndex < releaseIndex && currentIdCount > 0) {
                    idGenerator.freeId((long)((Long)idsTaken.remove(random.nextInt(currentIdCount))).intValue());
                    --currentIdCount;
                } else {
                    idsTaken.add(idGenerator.nextId());
                    ++currentIdCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                this.closeIdGenerator((IdGenerator)idGenerator);
                grabSize = random.nextInt(128) + 128;
                idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), grabSize, (long)(capacity * 2), false);
                ++numberOfCloses;
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsignedId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, IdType.PROPERTY_INDEX.getMaxValue(), false);
            idGenerator.setHighId(IdType.PROPERTY_INDEX.getMaxValue() - 1L);
            long id = idGenerator.nextId();
            Assert.assertEquals((long)(IdType.PROPERTY_INDEX.getMaxValue() - 1L), (long)id);
            idGenerator.freeId(id);
            try {
                idGenerator.nextId();
                Assert.fail((String)"Shouldn't be able to get next ID");
            }
            catch (StoreFailureException e) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, IdType.PROPERTY_INDEX.getMaxValue(), false);
            Assert.assertEquals((long)(IdType.PROPERTY_INDEX.getMaxValue() + 1L), (long)idGenerator.getHighId());
            id = idGenerator.nextId();
            Assert.assertEquals((long)(IdType.PROPERTY_INDEX.getMaxValue() - 1L), (long)id);
            try {
                idGenerator.nextId();
            }
            catch (StoreFailureException e) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    @Test
    public void makeSureIdCapacityCannotBeExceeded() throws Exception {
        for (IdType type : IdType.values()) {
            this.makeSureIdCapacityCannotBeExceeded(type);
        }
    }

    private void makeSureIdCapacityCannotBeExceeded(IdType type) {
        this.deleteIdGeneratorFile();
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        long maxValue = type.getMaxValue();
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, maxValue, false);
        long id = maxValue - 2L;
        idGenerator.setHighId(id);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 1L), (long)idGenerator.nextId());
        if (maxValue != (long)Math.pow(2.0, 32.0) - 1L) {
            Assert.assertEquals((long)(id + 2L), (long)idGenerator.nextId());
        }
        try {
            idGenerator.nextId();
            Assert.fail((String)("Id capacity shouldn't be able to be exceeded for " + type));
        }
        catch (StoreFailureException e) {
            // empty catch block
        }
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void makeSureMagicMinusOneIsntReturnedFromNodeIdGenerator() throws Exception {
        this.makeSureMagicMinusOneIsSkipped(IdType.NODE);
        this.makeSureMagicMinusOneIsSkipped(IdType.RELATIONSHIP);
        this.makeSureMagicMinusOneIsSkipped(IdType.PROPERTY);
    }

    private void makeSureMagicMinusOneIsSkipped(IdType type) {
        this.deleteIdGeneratorFile();
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, type.getMaxValue(), false);
        long id = (long)Math.pow(2.0, 32.0) - 3L;
        idGenerator.setHighId(id);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 1L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 3L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 4L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 5L), (long)idGenerator.nextId());
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void makeSureMagicMinusOneCannotBeReturnedEvenIfFreed() throws Exception {
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, IdType.NODE.getMaxValue(), false);
        long magicMinusOne = (long)Math.pow(2.0, 32.0) - 1L;
        idGenerator.setHighId(magicMinusOne);
        Assert.assertEquals((long)(magicMinusOne + 1L), (long)idGenerator.nextId());
        idGenerator.freeId(magicMinusOne - 1L);
        idGenerator.freeId(magicMinusOne);
        this.closeIdGenerator((IdGenerator)idGenerator);
        idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1, IdType.NODE.getMaxValue(), false);
        Assert.assertEquals((long)(magicMinusOne - 1L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(magicMinusOne + 2L), (long)idGenerator.nextId());
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void commandsGetWrittenOnceSoThatFreedIdsGetsAddedOnlyOnce() throws Exception {
        Relationship relationship;
        Node otherNode;
        int i;
        String storeDir = "target/var/free-id-once";
        FileUtils.deleteRecursively((File)new File(storeDir));
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"SOME_TYPE");
        Node rootNode = db.getReferenceNode();
        HashSet<Long> createdNodeIds = new HashSet<Long>();
        HashSet<Long> createdRelationshipIds = new HashSet<Long>();
        Transaction tx = db.beginTx();
        for (i = 0; i < 20; ++i) {
            otherNode = db.createNode();
            relationship = rootNode.createRelationshipTo(otherNode, (RelationshipType)type);
            if (i % 5 == 0) {
                otherNode.delete();
                relationship.delete();
                continue;
            }
            createdNodeIds.add(otherNode.getId());
            createdRelationshipIds.add(relationship.getId());
        }
        tx.success();
        tx.finish();
        db.shutdown();
        db = new EmbeddedGraphDatabase(storeDir);
        rootNode = db.getReferenceNode();
        tx = db.beginTx();
        for (i = 0; i < 100; ++i) {
            otherNode = db.createNode();
            if (!createdNodeIds.add(otherNode.getId())) {
                Assert.fail((String)"Managed to create a node with an id that was already in use");
            }
            if (createdRelationshipIds.add((relationship = rootNode.createRelationshipTo(otherNode, (RelationshipType)type)).getId())) continue;
            Assert.fail((String)"Managed to create a relationship with an id that was already in use");
        }
        tx.success();
        tx.finish();
        ((AbstractGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().clearCache();
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            IteratorUtil.lastOrNull((Iterable)node.getRelationships());
        }
        db.shutdown();
    }

    @Test
    public void delete() throws Exception {
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 10, 1000L, false);
        long id = idGenerator.nextId();
        idGenerator.nextId();
        idGenerator.freeId(id);
        idGenerator.close(true);
        idGenerator.delete();
        Assert.assertFalse((boolean)new File(this.idGeneratorFile()).exists());
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 10, 1000L, false);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        idGenerator.close(true);
    }
}

