/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.LongerShortString;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.TestShortString;

public class TestLongerShortString {
    @Test
    public void canEncodeEmptyString() {
        this.assertCanEncodeAndDecodeToSame("");
    }

    @Test
    public void canEncodeNumerical() {
        this.assertCanEncodeAndDecodeToSame("12345678901234567890");
        this.assertCanEncodeAndDecodeToSame("12345678901234567890 +-.,' 321,3");
    }

    @Test
    public void canEncodeDate() throws Exception {
        this.assertCanEncodeAndDecodeToSame("2011-10-10 12:45:22+0200");
        this.assertCanEncodeAndDecodeToSame("2011/10/10 12:45:22+0200");
    }

    @Test
    public void testRandomStrings() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            for (TestShortString.Charset charset : TestShortString.Charset.values()) {
                List<String> list = TestShortString.randomStrings(100, charset, 30);
                for (String string : list) {
                    PropertyBlock record;
                    if (!LongerShortString.encode((int)10, (String)string, (PropertyBlock)(record = new PropertyBlock()), (int)32)) continue;
                    Assert.assertEquals((Object)string, (Object)LongerShortString.decode((PropertyBlock)record));
                }
            }
        }
    }

    @Test
    public void canEncodeEmailAndUri() throws Exception {
        this.assertCanEncodeAndDecodeToSame("mattias@neotechnology.com");
        this.assertCanEncodeAndDecodeToSame("http://domain:7474/");
    }

    @Test
    public void canEncodeLower() throws Exception {
        this.assertCanEncodeAndDecodeToSame("folder/generators/templates/controller.ext");
        this.assertCanEncodeAndDecodeToSame("folder/generators/templates/controller.extr");
        this.assertCannotEncode("folder/generators/templates/controller.extra");
    }

    @Test
    public void checkMarginalFit() throws Exception {
        this.assertCanEncodeAndDecodeToSame("^aaaaaaaaaaaaaaaaaaaaaaaaaa");
        this.assertCannotEncode("^aaaaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    private void assertCanEncodeAndDecodeToSame(String string) {
        this.assertCanEncodeAndDecodeToSame(string, 32);
    }

    private void assertCanEncodeAndDecodeToSame(String string, int payloadSize) {
        PropertyBlock target = new PropertyBlock();
        Assert.assertTrue((boolean)LongerShortString.encode((int)0, (String)string, (PropertyBlock)target, (int)payloadSize));
        Assert.assertEquals((Object)string, (Object)LongerShortString.decode((PropertyBlock)target));
    }

    private void assertCannotEncode(String string) {
        this.assertCannotEncode(string, 32);
    }

    private void assertCannotEncode(String string, int payloadSize) {
        Assert.assertFalse((boolean)LongerShortString.encode((int)0, (String)string, (PropertyBlock)new PropertyBlock(), (int)payloadSize));
    }
}

