/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.transaction.FakeXAResource;
import org.neo4j.kernel.impl.transaction.MethodCall;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class TestJtaCompliance
extends AbstractNeo4jTestCase {
    private TransactionManager tm;
    private XaDataSourceManager xaDsMgr;

    @Before
    public void setUpFramework() {
        this.getTransaction().finish();
        TxModule txModule = this.getEmbeddedGraphDb().getConfig().getTxModule();
        this.tm = txModule.getTxManager();
        this.xaDsMgr = txModule.getXaDataSourceManager();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("xa_resource", new FakeXAResource("XAResource1"));
        map1.put("store_dir", "target/var");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("xa_resource", new FakeXAResource("XAResource2"));
        map2.put("store_dir", "target/var");
        try {
            this.xaDsMgr.registerDataSource("fakeRes1", (XaDataSource)new DummyXaDataSource(map1), UTF8.encode((String)"0xDDDDDE"));
            this.xaDsMgr.registerDataSource("fakeRes2", (XaDataSource)new DummyXaDataSource(map2), UTF8.encode((String)"0xDDDDDF"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.tm.commit();
        }
        catch (Exception e) {
            // empty catch block
        }
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown state of TM");
        }
        if (tx != null) {
            throw new RuntimeException("We're still in transaction");
        }
    }

    @After
    public void tearDownFramework() {
        this.xaDsMgr.unregisterDataSource("fakeRes1");
        this.xaDsMgr.unregisterDataSource("fakeRes2");
        try {
            if (this.tm.getTransaction() == null) {
                try {
                    this.tm.begin();
                }
                catch (Exception e) {}
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testBeginCommit() throws Exception {
        this.tm.begin();
        Assert.assertTrue((this.tm.getTransaction() != null ? 1 : 0) != 0);
        this.tm.commit();
        Assert.assertEquals((long)6L, (long)this.tm.getStatus());
        try {
            this.tm.rollback();
            Assert.fail((String)"rollback() should throw an exception -> STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.tm.commit();
            Assert.fail((String)"commit() should throw an exception -> STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testBeginRollback() throws Exception {
        this.tm.begin();
        Assert.assertTrue((this.tm.getTransaction() != null ? 1 : 0) != 0);
        this.tm.rollback();
        Assert.assertTrue((this.tm.getStatus() == 6 ? 1 : 0) != 0);
        try {
            this.tm.commit();
            Assert.fail((String)"commit() should throw an exception -> STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.tm.rollback();
            Assert.fail((String)"rollback() should throw an exception -> STATUS_NO_TRANSACTION");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspendResume() throws Exception {
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        FakeXAResource res = new FakeXAResource("XAResource1");
        tx.enlistResource((XAResource)res);
        Assert.assertTrue((this.tm.suspend() == tx ? 1 : 0) != 0);
        tx.delistResource((XAResource)res, 0x2000000);
        MethodCall[] calls = res.getAndRemoveMethodCalls();
        Assert.assertEquals((long)2L, (long)calls.length);
        Assert.assertEquals((Object)"start", (Object)calls[0].getMethodName());
        Object[] args = calls[0].getArgs();
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        Assert.assertEquals((Object)"end", (Object)calls[1].getMethodName());
        args = calls[1].getArgs();
        Assert.assertEquals((long)0x2000000L, (long)((Integer)args[1]).intValue());
        this.tm.resume(tx);
        tx.enlistResource((XAResource)res);
        calls = res.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls.length);
        Assert.assertEquals((Object)"start", (Object)calls[0].getMethodName());
        args = calls[0].getArgs();
        Assert.assertEquals((long)0x8000000L, (long)((Integer)args[1]).intValue());
        Assert.assertTrue((this.tm.getTransaction() == tx ? 1 : 0) != 0);
        tx.delistResource((XAResource)res, 0x4000000);
        this.tm.commit();
        this.tm.resume(tx);
        Assert.assertTrue((this.tm.getStatus() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((this.tm.getTransaction() == null ? 1 : 0) != 0);
    }

    @Test
    public void test2PhaseCommits1() throws Exception {
        byte[] branch2;
        this.tm.begin();
        FakeXAResource res1 = new FakeXAResource("XAResource1");
        FakeXAResource res2 = new FakeXAResource("XAResource2");
        this.tm.getTransaction().enlistResource((XAResource)res1);
        MethodCall[] calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"start", (Object)calls1[0].getMethodName());
        this.tm.getTransaction().enlistResource((XAResource)res2);
        MethodCall[] calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"start", (Object)calls2[0].getMethodName());
        Object[] args = calls1[0].getArgs();
        Xid xid1 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        args = calls2[0].getArgs();
        Xid xid2 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        byte[] globalTxId1 = xid1.getGlobalTransactionId();
        byte[] globalTxId2 = xid2.getGlobalTransactionId();
        Assert.assertTrue((globalTxId1.length == globalTxId2.length ? 1 : 0) != 0);
        for (int i = 0; i < globalTxId1.length; ++i) {
            Assert.assertEquals((long)globalTxId1[i], (long)globalTxId2[i]);
        }
        byte[] branch1 = xid1.getBranchQualifier();
        if (branch1.length == (branch2 = xid2.getBranchQualifier()).length) {
            boolean same = true;
            for (int i = 0; i < branch1.length; ++i) {
                if (branch1[i] == branch2[i]) continue;
                same = false;
                break;
            }
            Assert.assertTrue((!same ? 1 : 0) != 0);
        }
        this.tm.getTransaction().delistResource((XAResource)res2, 0x4000000);
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        this.tm.getTransaction().delistResource((XAResource)res1, 0x4000000);
        calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"end", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"end", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        this.tm.commit();
        calls1 = res1.getAndRemoveMethodCalls();
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)2L, (long)calls1.length);
        Assert.assertEquals((Object)"prepare", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((Object)"commit", (Object)calls1[1].getMethodName());
        args = calls1[1].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((Object)false, (Object)((Boolean)args[1]));
        Assert.assertEquals((long)2L, (long)calls2.length);
        Assert.assertEquals((Object)"prepare", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((Object)"commit", (Object)calls2[1].getMethodName());
        args = calls2[1].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((Object)false, (Object)((Boolean)args[1]));
    }

    @Test
    public void test2PhaseCommits2() throws Exception {
        this.tm.begin();
        FakeXAResource res1 = new FakeXAResource("XAResource1");
        FakeXAResource res2 = new FakeXAResource("XAResource1");
        this.tm.getTransaction().enlistResource((XAResource)res1);
        MethodCall[] calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"start", (Object)calls1[0].getMethodName());
        this.tm.getTransaction().enlistResource((XAResource)res2);
        MethodCall[] calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"start", (Object)calls2[0].getMethodName());
        FakeXAResource res3 = new FakeXAResource("XAResource2");
        this.tm.getTransaction().enlistResource((XAResource)res3);
        Object[] args = calls1[0].getArgs();
        Xid xid1 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        args = calls2[0].getArgs();
        Xid xid2 = (Xid)args[0];
        Assert.assertEquals((long)0x200000L, (long)((Integer)args[1]).intValue());
        Assert.assertTrue((boolean)xid1.equals(xid2));
        Assert.assertTrue((boolean)xid2.equals(xid1));
        this.tm.getTransaction().delistResource((XAResource)res3, 0x4000000);
        this.tm.getTransaction().delistResource((XAResource)res2, 0x4000000);
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        this.tm.getTransaction().delistResource((XAResource)res1, 0x4000000);
        calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"end", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"end", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        this.tm.commit();
        calls1 = res1.getAndRemoveMethodCalls();
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)2L, (long)calls1.length);
        Assert.assertEquals((Object)"prepare", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((Object)"commit", (Object)calls1[1].getMethodName());
        args = calls1[1].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((Object)false, (Object)((Boolean)args[1]));
        Assert.assertEquals((long)0L, (long)calls2.length);
    }

    @Test
    public void testRollback1() throws Exception {
        byte[] branch2;
        this.tm.begin();
        FakeXAResource res1 = new FakeXAResource("XAResource1");
        FakeXAResource res2 = new FakeXAResource("XAResource2");
        this.tm.getTransaction().enlistResource((XAResource)res1);
        MethodCall[] calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"start", (Object)calls1[0].getMethodName());
        this.tm.getTransaction().enlistResource((XAResource)res2);
        MethodCall[] calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"start", (Object)calls2[0].getMethodName());
        Object[] args = calls1[0].getArgs();
        Xid xid1 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        args = calls2[0].getArgs();
        Xid xid2 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        byte[] globalTxId1 = xid1.getGlobalTransactionId();
        byte[] globalTxId2 = xid2.getGlobalTransactionId();
        Assert.assertTrue((globalTxId1.length == globalTxId2.length ? 1 : 0) != 0);
        for (int i = 0; i < globalTxId1.length; ++i) {
            Assert.assertEquals((long)globalTxId1[i], (long)globalTxId2[i]);
        }
        byte[] branch1 = xid1.getBranchQualifier();
        if (branch1.length == (branch2 = xid2.getBranchQualifier()).length) {
            boolean same = true;
            for (int i = 0; i < branch1.length; ++i) {
                if (branch1[i] == branch2[i]) continue;
                same = false;
                break;
            }
            Assert.assertTrue((!same ? 1 : 0) != 0);
        }
        this.tm.getTransaction().delistResource((XAResource)res2, 0x4000000);
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        this.tm.getTransaction().delistResource((XAResource)res1, 0x4000000);
        calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"end", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"end", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        this.tm.rollback();
        calls1 = res1.getAndRemoveMethodCalls();
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"rollback", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"rollback", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
    }

    @Test
    public void testRollback2() throws Exception {
        this.tm.begin();
        FakeXAResource res1 = new FakeXAResource("XAResource1");
        FakeXAResource res2 = new FakeXAResource("XAResource1");
        this.tm.getTransaction().enlistResource((XAResource)res1);
        MethodCall[] calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"start", (Object)calls1[0].getMethodName());
        this.tm.getTransaction().enlistResource((XAResource)res2);
        MethodCall[] calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"start", (Object)calls2[0].getMethodName());
        Object[] args = calls1[0].getArgs();
        Xid xid1 = (Xid)args[0];
        Assert.assertEquals((long)0L, (long)((Integer)args[1]).intValue());
        args = calls2[0].getArgs();
        Xid xid2 = (Xid)args[0];
        Assert.assertEquals((long)0x200000L, (long)((Integer)args[1]).intValue());
        Assert.assertTrue((boolean)xid1.equals(xid2));
        Assert.assertTrue((boolean)xid2.equals(xid1));
        this.tm.getTransaction().delistResource((XAResource)res2, 0x4000000);
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls2.length);
        this.tm.getTransaction().delistResource((XAResource)res1, 0x4000000);
        calls1 = res1.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"end", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        Assert.assertEquals((long)1L, (long)calls2.length);
        Assert.assertEquals((Object)"end", (Object)calls2[0].getMethodName());
        args = calls2[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid2));
        Assert.assertEquals((long)0x4000000L, (long)((Integer)args[1]).intValue());
        this.tm.rollback();
        calls1 = res1.getAndRemoveMethodCalls();
        calls2 = res2.getAndRemoveMethodCalls();
        Assert.assertEquals((long)1L, (long)calls1.length);
        Assert.assertEquals((Object)"rollback", (Object)calls1[0].getMethodName());
        args = calls1[0].getArgs();
        Assert.assertTrue((boolean)((Xid)args[0]).equals(xid1));
        Assert.assertEquals((long)0L, (long)calls2.length);
    }

    @Test
    public void testNestedTransactions() throws Exception {
        Assert.assertTrue((this.tm.getTransaction() == null ? 1 : 0) != 0);
        this.tm.begin();
        Transaction txParent = this.tm.getTransaction();
        Assert.assertTrue((txParent != null ? 1 : 0) != 0);
        try {
            this.tm.begin();
        }
        catch (NotSupportedException notSupportedException) {
            // empty catch block
        }
        this.tm.commit();
        Assert.assertTrue((this.tm.getStatus() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionHook() throws Exception {
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        TxHook txHook = new TxHook();
        tx.registerSynchronization((Synchronization)txHook);
        Assert.assertEquals((Object)false, (Object)txHook.gotBefore);
        Assert.assertEquals((Object)false, (Object)txHook.gotAfter);
        this.tm.commit();
        Assert.assertEquals((Object)true, (Object)txHook.gotBefore);
        Assert.assertEquals((Object)true, (Object)txHook.gotAfter);
        Assert.assertTrue((tx == txHook.txBefore ? 1 : 0) != 0);
        Assert.assertTrue((tx == txHook.txAfter ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)txHook.statusBefore);
        Assert.assertEquals((long)3L, (long)txHook.statusAfter);
        this.tm.begin();
        tx = this.tm.getTransaction();
        txHook = new TxHook();
        tx.registerSynchronization((Synchronization)txHook);
        Assert.assertEquals((Object)false, (Object)txHook.gotBefore);
        Assert.assertEquals((Object)false, (Object)txHook.gotAfter);
        this.tm.rollback();
        Assert.assertEquals((Object)true, (Object)txHook.gotBefore);
        Assert.assertEquals((Object)true, (Object)txHook.gotAfter);
        Assert.assertTrue((tx == txHook.txBefore ? 1 : 0) != 0);
        Assert.assertTrue((tx == txHook.txAfter ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)txHook.statusBefore);
        Assert.assertEquals((long)4L, (long)txHook.statusAfter);
    }

    @Test
    public void testStatus() throws Exception {
        Assert.assertTrue((this.tm.getStatus() == 6 ? 1 : 0) != 0);
        this.tm.begin();
        Assert.assertTrue((this.tm.getStatus() == 0 ? 1 : 0) != 0);
        this.tm.getTransaction().setRollbackOnly();
        Assert.assertTrue((this.tm.getStatus() == 1 ? 1 : 0) != 0);
        this.tm.rollback();
        Assert.assertTrue((this.tm.getStatus() == 6 ? 1 : 0) != 0);
    }

    private static class DummyXaConnection
    implements XaConnection {
        private XAResource xaResource = null;

        public DummyXaConnection(XAResource xaResource) {
            this.xaResource = xaResource;
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }

        public void destroy() {
        }
    }

    public static class DummyXaDataSource
    extends XaDataSource {
        private XAResource xaResource = null;

        public DummyXaDataSource(Map<?, ?> map) throws InstantiationException {
            super(map);
            this.xaResource = (XAResource)map.get("xa_resource");
        }

        public void close() {
        }

        public XaConnection getXaConnection() {
            return new DummyXaConnection(this.xaResource);
        }

        public byte[] getBranchId() {
            return null;
        }

        public void setBranchId(byte[] branchId) {
        }

        public long getLastCommittedTxId() {
            return 0L;
        }
    }

    private class TxHook
    implements Synchronization {
        boolean gotBefore = false;
        boolean gotAfter = false;
        int statusBefore = -1;
        int statusAfter = -1;
        Transaction txBefore = null;
        Transaction txAfter = null;

        private TxHook() {
        }

        public void beforeCompletion() {
            try {
                this.statusBefore = TestJtaCompliance.this.tm.getStatus();
                this.txBefore = TestJtaCompliance.this.tm.getTransaction();
                this.gotBefore = true;
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }

        public void afterCompletion(int status) {
            try {
                this.statusAfter = status;
                this.txAfter = TestJtaCompliance.this.tm.getTransaction();
                Assert.assertTrue((status == TestJtaCompliance.this.tm.getStatus() ? 1 : 0) != 0);
                this.gotAfter = true;
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }
    }
}

