/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestContinueKeepLogs {
    private static final String PATH = "target/test-data/keep-logs";

    @Before
    public void cleanDb() throws Exception {
        FileUtils.deleteRecursively((File)new File(PATH));
    }

    @Test
    public void dontKeepLogsAndDoStuffWithoutKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.dontKeepLogs(), new int[0]);
        this.doStuffAndExpectLogs(this.dontKeepLogs(), new int[0]);
    }

    @Test
    public void dontKeepLogsAndDoStuffWithKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.dontKeepLogs(), new int[0]);
        this.doStuffAndExpectLogs(this.keepLogs(), 0);
    }

    @Test
    public void keepLogsAndDoStuffWithoutKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.keepLogs(), 0);
        this.doStuffAndExpectLogs(this.dontConfigureKeepLogs(), 0, 1);
    }

    @Test
    public void keepLogsForMeAndDoStuffWithoutKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.keepMyLogs(), 0);
        this.doStuffAndExpectLogs(this.dontConfigureKeepLogs(), 0, 1);
    }

    @Test
    public void keepLogsAndDoStuffWithPreventKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.keepLogs(), 0);
        this.doStuffAndExpectLogs(this.dontKeepLogs(), 0);
    }

    @Test
    public void keepLogsAndDoStuffWithPreventMeKeepLogsConfig() throws Exception {
        this.doStuffAndExpectLogs(this.keepLogs(), 0);
        this.doStuffAndExpectLogs(this.dontKeepMyLogs(), 0);
    }

    private Map<String, String> keepLogs() {
        return MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "true"});
    }

    private Map<String, String> dontKeepLogs() {
        return MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "false"});
    }

    private Map<String, String> dontKeepMyLogs() {
        return MapUtil.stringMap((String[])new String[]{"keep_logical_logs", this.dataSourceName() + "=false"});
    }

    private Map<String, String> keepMyLogs() {
        return MapUtil.stringMap((String[])new String[]{"keep_logical_logs", this.dataSourceName() + "=true"});
    }

    protected String dataSourceName() {
        return "nioneodb";
    }

    private Map<String, String> dontConfigureKeepLogs() {
        return MapUtil.stringMap((String[])new String[0]);
    }

    private void doStuffAndExpectLogs(Map<String, String> config, int ... expectedLogVersions) throws Exception {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH, config);
        this.doTransaction((GraphDatabaseService)db);
        db.shutdown();
        this.expectLogs((GraphDatabaseService)db, expectedLogVersions);
    }

    protected File logDir(GraphDatabaseService db) {
        return new File(((AbstractGraphDatabase)db).getStoreDir());
    }

    private void expectLogs(GraphDatabaseService db, int ... versions) {
        HashSet<Integer> versionSet = new HashSet<Integer>();
        for (int version : versions) {
            versionSet.add(version);
        }
        Pattern pattern = Pattern.compile(".*\\.v\\d+");
        for (File file : this.logDir(db).listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            Assert.assertTrue((boolean)versionSet.remove(this.getLogVersion(file)));
        }
        Assert.assertEquals((String)("Expected logs " + versionSet), (long)0L, (long)versionSet.size());
    }

    private int getLogVersion(File file) {
        return Integer.parseInt(file.getName().substring(file.getName().indexOf(118) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransaction(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            this.doTransactionWork(db);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected void doTransactionWork(GraphDatabaseService db) {
        db.createNode();
    }
}

