/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.RollbackUnclean;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.TargetDirectory;

public class TestTxEntries {
    @Test
    public void testStartEntryWrittenOnceOnRollback() throws Exception {
        String storeDir = TargetDirectory.forTest(TestTxEntries.class).directory("rollBack", true).getAbsolutePath();
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), RollbackUnclean.class.getName(), storeDir});
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        Thread out = new Thread(new StreamConsumer(stdout, System.out));
        Thread err = new Thread(new StreamConsumer(stderr, System.err));
        out.start();
        err.start();
        out.join();
        err.join();
        int exit = process.waitFor();
        Assert.assertEquals((long)0L, (long)exit);
        new EmbeddedGraphDatabase(storeDir).shutdown();
    }
}

