/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class CircularGraphTest
extends AbstractTestBase {
    @BeforeClass
    public static void createTheGraph() {
        CircularGraphTest.createGraph("1 TO 2", "2 TO 3", "3 TO 1");
    }

    @Test
    public void testCircularBug() {
        long timestamp = 3L;
        Transaction tx = CircularGraphTest.beginTx();
        this.getNodeWithName("2").setProperty("timestamp", (Object)1L);
        this.getNodeWithName("3").setProperty("timestamp", (Object)2L);
        tx.success();
        tx.finish();
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"TO");
        Traverser t = CircularGraphTest.node("1").traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator((RelationshipType)type){
            final /* synthetic */ RelationshipType val$type;
            {
                this.val$type = relationshipType;
            }

            public boolean isStopNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                if (last != null && last.isType(this.val$type)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty("timestamp");
                    return currentTime >= 3L;
                }
                return false;
            }
        }, new ReturnableEvaluator((RelationshipType)type){
            final /* synthetic */ RelationshipType val$type;
            {
                this.val$type = relationshipType;
            }

            public boolean isReturnableNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                return last != null && last.isType(this.val$type);
            }
        }, (RelationshipType)type, Direction.OUTGOING);
        Iterator nodes = t.iterator();
        Assert.assertEquals((Object)"2", (Object)((Node)nodes.next()).getProperty("name"));
        Assert.assertEquals((Object)"3", (Object)((Node)nodes.next()).getProperty("name"));
        Assert.assertFalse((boolean)nodes.hasNext());
    }
}

