/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestPath
extends AbstractTestBase {
    @BeforeClass
    public static void setup() {
        TestPath.createGraph("A TO B", "B TO C", "C TO D", "D TO E");
    }

    @Test
    public void testPathIterator() {
        Path path = (Path)Traversal.description().evaluator(Evaluators.atDepth((int)4)).traverse(TestPath.node("A")).iterator().next();
        this.assertPathIsCorrect(path);
    }

    private void assertPathIsCorrect(Path path) {
        Node a = TestPath.node("A");
        Relationship to1 = (Relationship)a.getRelationships(Direction.OUTGOING).iterator().next();
        Node b = to1.getEndNode();
        Relationship to2 = (Relationship)b.getRelationships(Direction.OUTGOING).iterator().next();
        Node c = to2.getEndNode();
        Relationship to3 = (Relationship)c.getRelationships(Direction.OUTGOING).iterator().next();
        Node d = to3.getEndNode();
        Relationship to4 = (Relationship)d.getRelationships(Direction.OUTGOING).iterator().next();
        Node e = to4.getEndNode();
        Assert.assertEquals((Object)4, (Object)path.length());
        Assert.assertEquals((Object)a, (Object)path.startNode());
        Assert.assertEquals((Object)e, (Object)path.endNode());
        Assert.assertEquals((Object)to4, (Object)path.lastRelationship());
        Iterator pathEntities = path.iterator();
        Assert.assertEquals((Object)a, pathEntities.next());
        Assert.assertEquals((Object)to1, pathEntities.next());
        Assert.assertEquals((Object)b, pathEntities.next());
        Assert.assertEquals((Object)to2, pathEntities.next());
        Assert.assertEquals((Object)c, pathEntities.next());
        Assert.assertEquals((Object)to3, pathEntities.next());
        Assert.assertEquals((Object)d, pathEntities.next());
        Assert.assertEquals((Object)to4, pathEntities.next());
        Assert.assertEquals((Object)e, pathEntities.next());
        Assert.assertFalse((boolean)pathEntities.hasNext());
        Iterator nodes = path.nodes().iterator();
        Assert.assertEquals((Object)a, nodes.next());
        Assert.assertEquals((Object)b, nodes.next());
        Assert.assertEquals((Object)c, nodes.next());
        Assert.assertEquals((Object)d, nodes.next());
        Assert.assertEquals((Object)e, nodes.next());
        Assert.assertFalse((boolean)nodes.hasNext());
        Iterator relationships = path.relationships().iterator();
        Assert.assertEquals((Object)to1, relationships.next());
        Assert.assertEquals((Object)to2, relationships.next());
        Assert.assertEquals((Object)to3, relationships.next());
        Assert.assertEquals((Object)to4, relationships.next());
        Assert.assertFalse((boolean)relationships.hasNext());
    }
}

