/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestEphemeralFileChannel {
    @Test
    public void smoke() throws Exception {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        FileChannel channel = fs.open("yo", "rw");
        ByteBuffer buffer = ByteBuffer.allocateDirect(23);
        buffer.put(new byte[23]);
        buffer.flip();
        channel.write(buffer);
        channel = fs.open("yo", "rw");
        long longValue = 1234567890L;
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)1);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)2);
        buffer.flip();
        channel.position(6L);
        channel.write(buffer);
        buffer.clear();
        buffer.limit(8);
        buffer.putLong(longValue);
        buffer.flip();
        channel.position(15L);
        channel.write(buffer);
        Assert.assertEquals((long)23L, (long)channel.size());
        buffer.clear();
        buffer.limit(1);
        channel.read(buffer, 0L);
        buffer.flip();
        Assert.assertEquals((long)1L, (long)buffer.get());
        buffer.clear();
        buffer.limit(3);
        channel.read(buffer, 5L);
        buffer.flip();
        Assert.assertEquals((long)0L, (long)buffer.get());
        Assert.assertEquals((long)2L, (long)buffer.get());
        Assert.assertEquals((long)0L, (long)buffer.get());
        buffer.clear();
        buffer.limit(8);
        channel.read(buffer, 15L);
        buffer.flip();
        Assert.assertEquals((long)longValue, (long)buffer.getLong());
    }
}

