/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.tooling.GlobalGraphOperations;

public class GraphDescription
implements GraphDefinition {
    private static final PROP[] NO_PROPS = new PROP[0];
    private static final NODE[] NO_NODES = new NODE[0];
    private static final REL[] NO_RELS = new REL[0];
    private static final GraphDescription EMPTY = new GraphDescription(NO_NODES, NO_RELS, false, false){

        @Override
        public Map<String, Node> create(GraphDatabaseService graphdb) {
            return new HashMap<String, Node>();
        }
    };
    private final NODE[] nodes;
    private final REL[] rels;
    private final boolean autoIndexRelationships;
    private final boolean autoIndexNodes;

    public static TestData.Producer<Map<String, Node>> createGraphFor(final GraphHolder holder, final boolean destroy) {
        return new TestData.Producer<Map<String, Node>>(){

            @Override
            public Map<String, Node> create(GraphDefinition graph, String title, String documentation) {
                return graph.create(holder.graphdb());
            }

            @Override
            public void destroy(Map<String, Node> product, boolean successful) {
                if (destroy) {
                    GraphDescription.destroy(product);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Node> create(GraphDatabaseService graphdb) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        Transaction tx = graphdb.beginTx();
        try {
            graphdb.index().getRelationshipAutoIndexer().setEnabled(this.autoIndexRelationships);
            for (NODE nODE : this.nodes) {
                result.put(nODE.name(), GraphDescription.init(graphdb.createNode(), nODE.setNameProperty() ? nODE.name() : null, nODE.properties(), graphdb.index().getNodeAutoIndexer(), this.autoIndexNodes));
            }
            for (Annotation annotation : this.rels) {
                GraphDescription.init(((Node)result.get(annotation.start())).createRelationshipTo((Node)result.get(annotation.end()), (RelationshipType)DynamicRelationshipType.withName((String)annotation.type())), annotation.setNameProperty() ? annotation.name() : null, annotation.properties(), graphdb.index().getRelationshipAutoIndexer(), this.autoIndexRelationships);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    private static <T extends PropertyContainer> T init(T entity, String name, PROP[] properties, AutoIndexer<T> autoindex, boolean auto) {
        autoindex.setEnabled(auto);
        for (PROP prop : properties) {
            if (auto) {
                autoindex.startAutoIndexingProperty(prop.key());
            }
            entity.setProperty(prop.key(), prop.type().convert(prop.value()));
        }
        if (name != null) {
            if (auto) {
                autoindex.startAutoIndexingProperty("name");
            }
            entity.setProperty("name", (Object)name);
        }
        return entity;
    }

    public static GraphDescription create(String ... definition) {
        HashMap<String, NODE> nodes = new HashMap<String, NODE>();
        ArrayList<REL> relationships = new ArrayList<REL>();
        GraphDescription.parse(definition, nodes, relationships);
        return new GraphDescription(nodes.values().toArray(NO_NODES), relationships.toArray(NO_RELS), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Map<String, Node> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        GraphDatabaseService db = nodes.values().iterator().next().getGraphDatabase();
        Transaction tx = db.beginTx();
        try {
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                for (Relationship rel : node.getRelationships()) {
                    rel.delete();
                }
                node.delete();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public static GraphDescription create(Graph graph) {
        if (graph == null) {
            return EMPTY;
        }
        HashMap<String, NODE> nodes = new HashMap<String, NODE>();
        for (NODE node : graph.nodes()) {
            if (nodes.put(GraphDescription.defined(node.name()), node) == null) continue;
            throw new IllegalArgumentException("Node \"" + node.name() + "\" defined more than once");
        }
        HashMap<String, REL> rels = new HashMap<String, REL>();
        ArrayList<REL> relationships = new ArrayList<REL>();
        for (REL rel : graph.relationships()) {
            GraphDescription.createIfAbsent(nodes, rel.start());
            GraphDescription.createIfAbsent(nodes, rel.end());
            String name = rel.name();
            if (!name.equals("") && rels.put(name, rel) != null) {
                throw new IllegalArgumentException("Relationship \"" + name + "\" defined more than once");
            }
            relationships.add(rel);
        }
        GraphDescription.parse(graph.value(), nodes, relationships);
        return new GraphDescription(nodes.values().toArray(NO_NODES), relationships.toArray(NO_RELS), graph.autoIndexNodes(), graph.autoIndexRelationships());
    }

    private static void createIfAbsent(Map<String, NODE> nodes, String name) {
        if (!nodes.containsKey(name)) {
            nodes.put(name, new DefaultNode(name));
        }
    }

    private static void parse(String[] description, Map<String, NODE> nodes, List<REL> relationships) {
        for (String part : description) {
            for (String line : part.split("\n")) {
                String[] components = line.split(" ");
                if (components.length != 3) {
                    throw new IllegalArgumentException("syntax error: \"" + line + "\"");
                }
                GraphDescription.createIfAbsent(nodes, GraphDescription.defined(components[0]));
                GraphDescription.createIfAbsent(nodes, GraphDescription.defined(components[2]));
                relationships.add(new DefaultRel(components[0], components[1], components[2]));
            }
        }
    }

    private GraphDescription(NODE[] nodes, REL[] rels, boolean autoIndexNodes, boolean autoIndexRelationships) {
        this.nodes = nodes;
        this.rels = rels;
        this.autoIndexNodes = autoIndexNodes;
        this.autoIndexRelationships = autoIndexRelationships;
    }

    static String defined(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Node name not provided");
        }
        return name;
    }

    private static class DefaultRel
    extends Default
    implements REL {
        private final String start;
        private final String type;
        private final String end;

        DefaultRel(String start, String type, String end) {
            super(null);
            this.type = type;
            this.start = GraphDescription.defined(start);
            this.end = GraphDescription.defined(end);
        }

        @Override
        public String start() {
            return this.start;
        }

        @Override
        public String end() {
            return this.end;
        }

        @Override
        public String type() {
            return this.type;
        }
    }

    private static class DefaultNode
    extends Default
    implements NODE {
        DefaultNode(String name) {
            super(name);
        }
    }

    private static class Default {
        private final String name;

        Default(String name) {
            this.name = "".equals(name) ? null : name;
        }

        public String name() {
            return this.name;
        }

        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("this is not a real annotation");
        }

        public PROP[] properties() {
            return NO_PROPS;
        }

        public boolean setNameProperty() {
            return true;
        }
    }

    public static enum PropType {
        STRING{

            @Override
            String convert(String value) {
                return value;
            }
        }
        ,
        INTEGER{

            @Override
            Long convert(String value) {
                return Long.parseLong(value);
            }
        }
        ,
        DOUBLE{

            @Override
            Double convert(String value) {
                return Double.parseDouble(value);
            }
        }
        ,
        BOOLEAN{

            @Override
            Boolean convert(String value) {
                return Boolean.parseBoolean(value);
            }
        };


        abstract Object convert(String var1);
    }

    @Target(value={})
    public static @interface PROP {
        public String key();

        public String value();

        public PropType type() default PropType.STRING;
    }

    @Target(value={})
    public static @interface REL {
        public String name() default "";

        public String type();

        public String start();

        public String end();

        public PROP[] properties() default {};

        public boolean setNameProperty() default false;
    }

    @Target(value={})
    public static @interface NODE {
        public String name();

        public PROP[] properties() default {};

        public boolean setNameProperty() default false;
    }

    @Inherited
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Graph {
        public String[] value() default {};

        public NODE[] nodes() default {};

        public REL[] relationships() default {};

        public boolean autoIndexNodes() default false;

        public boolean autoIndexRelationships() default false;
    }
}

