/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class EphemeralFileSystemAbstraction
implements FileSystemAbstraction {
    private final Map<String, EphemeralFileChannel> files = new HashMap<String, EphemeralFileChannel>();

    public synchronized void dispose() {
        for (EphemeralFileChannel file : this.files.values()) {
            this.free(file);
        }
        this.files.clear();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void free(EphemeralFileChannel fileChannel) {
        if (fileChannel != null) {
            fileChannel.fileAsBuffer.free();
        }
    }

    public synchronized FileChannel open(String fileName, String mode) throws IOException {
        EphemeralFileChannel file = this.files.get(fileName);
        return file != null ? file.reset() : this.create(fileName);
    }

    public org.neo4j.kernel.impl.nioneo.store.FileLock tryLock(String fileName, FileChannel channel) throws IOException {
        return org.neo4j.kernel.impl.nioneo.store.FileLock.getOsSpecificFileLock((String)fileName, (FileChannel)channel);
    }

    public synchronized FileChannel create(String fileName) throws IOException {
        EphemeralFileChannel file = new EphemeralFileChannel();
        this.free(this.files.put(fileName, file));
        return file;
    }

    public long getFileSize(String fileName) {
        EphemeralFileChannel file = this.files.get(fileName);
        return file == null ? 0L : file.size();
    }

    public boolean fileExists(String fileName) {
        return this.files.containsKey(fileName);
    }

    public boolean deleteFile(String fileName) {
        this.free(this.files.remove(fileName));
        return true;
    }

    public boolean renameFile(String from, String to) throws IOException {
        EphemeralFileChannel file = this.files.remove(from);
        if (file == null) {
            throw new IOException("'" + from + "' doesn't exist");
        }
        if (this.files.containsKey(to)) {
            throw new IOException("'" + to + "' already exists");
        }
        this.files.put(to, file);
        return true;
    }

    private static class DynamicByteBuffer {
        private static final int[] SIZES;
        private static volatile AtomicReferenceArray<Queue<Reference<ByteBuffer>>> POOL;
        private ByteBuffer buf = this.allocate(0);

        private ByteBuffer allocate(int sizeIndex) {
            for (int enlargement = 0; enlargement < 2; ++enlargement) {
                Reference<ByteBuffer> ref;
                Queue<Reference<ByteBuffer>> queue;
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
                if (sizeIndex + enlargement >= pool.length() || (queue = pool.get(sizeIndex + enlargement)) == null) continue;
                while ((ref = queue.poll()) != null) {
                    ByteBuffer buffer = ref.get();
                    if (buffer == null) continue;
                    return buffer;
                }
            }
            return ByteBuffer.allocateDirect(sizeIndex < SIZES.length ? SIZES[sizeIndex] : (sizeIndex - SIZES.length + 1) * SIZES[SIZES.length - 1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free() {
            try {
                int sizeIndex;
                this.clear();
                if (sizeIndex == 0) {
                    for (sizeIndex = this.buf.capacity() / SIZES[SIZES.length - 1]; sizeIndex < SIZES.length && this.buf.capacity() != SIZES[sizeIndex]; ++sizeIndex) {
                    }
                } else {
                    sizeIndex += SIZES.length - 1;
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
                SoftReference<ByteBuffer> ref = new SoftReference<ByteBuffer>(this.buf);
                (sizeIndex < pool.length() ? pool.get(sizeIndex) : DynamicByteBuffer.growPool(sizeIndex)).add(ref);
            }
            finally {
                this.buf = null;
            }
        }

        private static synchronized Queue<Reference<ByteBuffer>> growPool(int sizeIndex) {
            AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pool = POOL;
            if (sizeIndex >= pool.length()) {
                int i;
                int newSize;
                for (newSize = pool.length(); sizeIndex >= newSize; newSize <<= 1) {
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> newPool = new AtomicReferenceArray<Queue<Reference<ByteBuffer>>>(newSize);
                for (i = 0; i < pool.length(); ++i) {
                    newPool.set(i, pool.get(i));
                }
                for (i = pool.length(); i < newPool.length(); ++i) {
                    newPool.set(i, new ConcurrentLinkedQueue());
                }
                POOL = pool = newPool;
            }
            return pool.get(sizeIndex);
        }

        public void put(int b) {
            this.verifySize(1);
            this.buf.put((byte)b);
        }

        public void put(byte[] bytes) {
            this.verifySize(bytes.length);
            this.buf.put(bytes);
        }

        public void put(byte[] bytes, int offset, int length) {
            this.verifySize(length);
            this.buf.put(bytes, offset, length);
        }

        public void put(ByteBuffer from) {
            this.verifySize(from.capacity() - from.remaining());
            this.buf.put(from);
        }

        public void putCharacter(char c) {
            this.verifySize(2);
            this.buf.putChar(c);
        }

        public void putShort(short s) {
            this.verifySize(2);
            this.buf.putShort(s);
        }

        public void putInteger(int i) {
            this.verifySize(4);
            this.buf.putInt(i);
        }

        public void putFloat(float f) {
            this.verifySize(4);
            this.buf.putFloat(f);
        }

        public void putDouble(double d) {
            this.verifySize(8);
            this.buf.putDouble(d);
        }

        public void putLong(long l) {
            this.verifySize(8);
            this.buf.putLong(l);
        }

        private void verifySize(int amount) {
            if (this.buf.remaining() >= amount) {
                return;
            }
            int newSize = this.buf.capacity();
            int sizeIndex = newSize / SIZES[SIZES.length - 1];
            if (sizeIndex == 0) {
                while (sizeIndex < SIZES.length && newSize != SIZES[sizeIndex]) {
                    ++sizeIndex;
                }
            } else {
                sizeIndex += SIZES.length - 1;
            }
            int required = newSize + amount - this.buf.remaining();
            while (newSize < required) {
                newSize += Math.min(newSize, 0x100000);
                ++sizeIndex;
            }
            int oldPosition = this.buf.position();
            ByteBuffer buf = this.allocate(sizeIndex);
            this.buf.position(0);
            buf.put(this.buf);
            this.buf = buf;
            this.buf.position(oldPosition);
        }

        public void get(byte[] scratchPad, int i, int howMuchToReadThisTime) {
            this.buf.get(scratchPad, i, howMuchToReadThisTime);
        }

        public void clear() {
            this.buf.clear();
        }

        public void position(int i) {
            this.buf.position(i);
        }

        public int position() {
            return this.buf.position();
        }

        static {
            int K = 1024;
            SIZES = new int[]{64 * K, 128 * K, 256 * K, 512 * K, 1024 * K};
            POOL = new AtomicReferenceArray(SIZES.length);
            AtomicReferenceArray pool = POOL;
            for (int i = 0; i < SIZES.length; ++i) {
                pool.set(i, new ConcurrentLinkedQueue());
            }
        }
    }

    private static class EphemeralFileLock
    extends FileLock {
        private final EphemeralFileChannel channel;
        private boolean released;

        EphemeralFileLock(EphemeralFileChannel channel) {
            super(channel, 0L, Long.MAX_VALUE, false);
            this.channel = channel;
            channel.locked++;
        }

        @Override
        public boolean isValid() {
            return !this.released;
        }

        @Override
        public void release() throws IOException {
            if (this.released) {
                return;
            }
            this.channel.locked--;
            this.released = true;
        }
    }

    private static class EphemeralFileChannel
    extends FileChannel {
        private final DynamicByteBuffer fileAsBuffer = new DynamicByteBuffer();
        private final byte[] scratchPad = new byte[1024];
        private static final byte[] zeroBuffer = new byte[1024];
        private int size;
        private int locked;

        private EphemeralFileChannel() {
        }

        @Override
        public int read(ByteBuffer dst) {
            int available;
            int howMuchToReadThisTime;
            int wanted = dst.limit();
            for (int pending = available = Math.min(wanted, (int)((long)this.size - this.position())); pending > 0; pending -= howMuchToReadThisTime) {
                howMuchToReadThisTime = Math.min(pending, this.scratchPad.length);
                this.fileAsBuffer.get(this.scratchPad, 0, howMuchToReadThisTime);
                dst.put(this.scratchPad, 0, howMuchToReadThisTime);
            }
            this.fillWithZeros(dst, available - wanted);
            return wanted;
        }

        private void fillWithZeros(ByteBuffer target, int bytes) {
            while (bytes > 0) {
                int howMuchToReadThisTime = Math.min(bytes, zeroBuffer.length);
                target.put(zeroBuffer, 0, howMuchToReadThisTime);
                bytes -= howMuchToReadThisTime;
            }
        }

        public EphemeralFileChannel reset() {
            this.fileAsBuffer.position(0);
            return this;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) {
            int wanted;
            int howMuchToWriteThisTime;
            for (int pending = wanted = src.limit(); pending > 0; pending -= howMuchToWriteThisTime) {
                howMuchToWriteThisTime = Math.min(pending, this.scratchPad.length);
                src.get(this.scratchPad, 0, howMuchToWriteThisTime);
                this.fileAsBuffer.put(this.scratchPad, 0, howMuchToWriteThisTime);
            }
            int newSize = Math.max(this.size, (int)this.position());
            int intermediaryBytes = newSize - wanted - this.size;
            if (intermediaryBytes > 0) {
                int oldPos = this.fileAsBuffer.position();
                try {
                    this.fileAsBuffer.position(this.size);
                    this.fillWithZeros(this.fileAsBuffer.buf, intermediaryBytes);
                }
                finally {
                    this.fileAsBuffer.position(oldPos);
                }
            }
            this.size = newSize;
            return wanted;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() {
            return this.fileAsBuffer.position();
        }

        @Override
        public FileChannel position(long newPosition) {
            this.fileAsBuffer.position((int)newPosition);
            return this;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public FileChannel truncate(long size) {
            this.size = (int)size;
            return this;
        }

        @Override
        public void force(boolean metaData) {
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst, long position) {
            long previous = this.position();
            this.position(position);
            try {
                int n = this.read(dst);
                return n;
            }
            finally {
                this.position(previous);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src, long position) {
            long previous = this.position();
            this.position(position);
            try {
                int n = this.write(src);
                return n;
            }
            finally {
                this.position(previous);
            }
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            if (this.locked > 0) {
                return null;
            }
            return new EphemeralFileLock(this);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            if (this.locked > 0) {
                throw new IOException("Locked");
            }
            return new EphemeralFileLock(this);
        }

        @Override
        protected void implCloseChannel() throws IOException {
        }
    }
}

