/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.KillSubProcess;
import org.neo4j.test.subprocess.SubProcess;

public abstract class BreakPoint
implements DebuggerDeadlockCallback {
    final Event event;
    final String type;
    private final String method;
    private final String[] args;
    volatile boolean enabled = false;
    private EventRequest request = null;

    public BreakPoint(Class<?> type, String method, Class<?> ... args) {
        this(Event.ENTRY, type, method, args);
    }

    public BreakPoint(Event event, Class<?> type, String method, Class<?> ... args) {
        this.event = event;
        this.type = type.getName();
        this.method = method;
        this.args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.args[i] = args[i].getName();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("BreakPoint[");
        result.append(this.type).append('#').append(this.method).append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.args[i]);
        }
        return result.append(")]").toString();
    }

    protected abstract void callback(DebugInterface var1) throws KillSubProcess;

    @Override
    public void deadlock(DebuggedThread thread) {
        SubProcess.DebugDispatch.defaultCallback.deadlock(thread);
    }

    public synchronized BreakPoint enable() {
        this.enabled = true;
        if (this.request != null) {
            this.request.enable();
        }
        return this;
    }

    public synchronized BreakPoint disable() {
        this.enabled = false;
        if (this.request != null) {
            this.request.disable();
        }
        return this;
    }

    synchronized void setRequest(EventRequest request) {
        this.request = request;
        this.request.setEnabled(this.enabled);
    }

    void setup(ReferenceType type) {
        EventRequestManager erm = type.virtualMachine().eventRequestManager();
        for (Method method : type.methodsByName(this.method)) {
            if (!this.matches(method.name(), method.argumentTypeNames())) continue;
            switch (this.event) {
                case ENTRY: {
                    this.setRequest(erm.createBreakpointRequest(method.location()));
                    return;
                }
                case EXIT: {
                    MethodExitRequest request = erm.createMethodExitRequest();
                    request.addClassFilter(type);
                    this.setRequest(request);
                }
            }
            return;
        }
    }

    boolean matches(String name, List<String> argNames) {
        if (!name.equals(this.method)) {
            return false;
        }
        if (argNames.size() != this.args.length) {
            return false;
        }
        Iterator<String> names = argNames.iterator();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(names.next())) continue;
            return false;
        }
        return true;
    }

    public static BreakPoint stacktrace(final PrintStream out, Class<?> type, String method, Class<?> ... args) {
        return new BreakPoint(type, method, (Class[])args){

            @Override
            protected void callback(DebugInterface debug) {
                out.println("Debugger stacktrace");
                debug.printStackTrace(out);
            }
        };
    }

    public static BreakPoint thatCrashesTheProcess(final CountDownLatch crashNotification, final int letNumberOfCallsPass, Class<?> type, String method, Class<?> ... args) {
        return new BreakPoint(type, method, (Class[])args){
            private volatile int numberOfCalls;

            @Override
            protected void callback(DebugInterface debug) throws KillSubProcess {
                if (++this.numberOfCalls <= letNumberOfCallsPass) {
                    return;
                }
                debug.thread().suspend(null);
                this.disable();
                crashNotification.countDown();
                throw KillSubProcess.withExitCode(-1);
            }
        };
    }

    public static enum Event {
        ENTRY,
        EXIT;

    }
}

