/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.event.LocatableEvent;
import java.io.PrintStream;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.SubProcess;

public class DebugInterface {
    private final LocatableEvent event;
    private final SubProcess.DebugDispatch debug;

    DebugInterface(SubProcess.DebugDispatch debug, LocatableEvent event) {
        this.debug = debug;
        this.event = event;
    }

    public boolean matchCallingMethod(int offset, Class<?> owner, String method) {
        try {
            Location location = this.event.thread().frame(offset).location();
            if (owner != null && !owner.getName().equals(location.declaringType().name())) {
                return false;
            }
            return method == null || method.equals(location.method().name());
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
    }

    public DebuggedThread thread() {
        return new DebuggedThread(this.debug, this.event.thread());
    }

    public void printStackTrace(PrintStream out) {
        this.thread().printStackTrace(out);
    }
}

