/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.SubProcess;

public class DebuggedThread {
    private final ThreadReference thread;
    private final SubProcess.DebugDispatch debug;

    DebuggedThread(SubProcess.DebugDispatch debug, ThreadReference thread) {
        this.debug = debug;
        this.thread = thread;
    }

    public String toString() {
        return "DebuggedThread[" + this.debug.handler + " " + this.thread.name() + "]";
    }

    public DebuggedThread suspend(DebuggerDeadlockCallback callback) {
        this.thread.suspend();
        this.debug.suspended(this.thread, callback);
        return this;
    }

    public DebuggedThread resume() {
        this.thread.resume();
        this.debug.resume(this.thread);
        return this;
    }

    public String getLocal(int offset, String name) {
        try {
            StackFrame frame = this.thread.frames().get(offset);
            LocalVariable variable = frame.visibleVariableByName(name);
            return frame.getValue(variable).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public StackTraceElement[] getStackTrace() {
        try {
            List<StackFrame> frames = this.thread.frames();
            StackTraceElement[] trace = new StackTraceElement[frames.size()];
            Iterator<StackFrame> iter = frames.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String fileName;
                Location loc = iter.next().location();
                Method method = loc.method();
                try {
                    fileName = loc.sourceName();
                }
                catch (AbsentInformationException e) {
                    fileName = null;
                }
                trace[i] = new StackTraceElement(method.declaringType().name(), method.name(), fileName, loc.lineNumber());
                ++i;
            }
            return trace;
        }
        catch (IncompatibleThreadStateException e) {
            return new StackTraceElement[0];
        }
    }

    public String name() {
        return this.thread.name();
    }

    public void printStackTrace(PrintStream out) {
        out.println(this.name());
        for (StackTraceElement trace : this.getStackTrace()) {
            out.println("\tat " + trace);
        }
    }
}

