/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.database.DatabaseBlockedException;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;

public class RetrieveRelationshipsFromNodeFunctionalTest
extends AbstractRestFunctionalTestBase {
    private long nodeWithRelationships;
    private long nodeWithoutRelationships;
    private long nonExistingNode;
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;
    private long likes;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(RetrieveRelationshipsFromNodeFunctionalTest.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        this.cleanDatabase();
        this.createSimpleGraph();
    }

    private void createSimpleGraph() {
        this.nodeWithRelationships = helper.createNode();
        this.likes = helper.createRelationship("LIKES", this.nodeWithRelationships, helper.createNode());
        helper.createRelationship("LIKES", helper.createNode(), this.nodeWithRelationships);
        helper.createRelationship("HATES", this.nodeWithRelationships, helper.createNode());
        this.nodeWithoutRelationships = helper.createNode();
        this.nonExistingNode = this.nodeWithoutRelationships * 100L;
    }

    private JaxRsResponse sendRetrieveRequestToServer(long nodeId, String path) {
        return RestRequest.req().get(functionalTestHelper.nodeUri() + "/" + nodeId + "/relationships" + path);
    }

    private void verifyRelReps(int expectedSize, String json) throws JsonParseException {
        List relreps = JsonHelper.jsonToList((String)json);
        Assert.assertEquals((long)expectedSize, (long)relreps.size());
        for (Map relrep : relreps) {
            RelationshipRepresentationTest.verifySerialisation(relrep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInRelationshipRepresentationWithHostHeaderValue() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet("http://localhost:7474/db/data/relationship/" + this.likes);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("Host", "dummy.neo4j.org");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
            System.out.println(entityBody);
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)("http://dummy.neo4j.org/db/data/relationship/" + this.likes)));
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"localhost:7474")));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInRelationshipRepresentationWithoutHostHeaderUsingRequestUri() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet("http://localhost:7474/db/data/relationship/" + this.likes);
            httpget.setHeader("Accept", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)("http://localhost:7474/db/data/relationship/" + this.likes)));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    @Documented(value=" Get all relationships.\n")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingAllRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships" + "/all").entity();
        this.verifyRelReps(3, entity);
    }

    @Documented(value=" Get incoming relationships.\n")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingIncomingRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships" + "/in").entity();
        this.verifyRelReps(1, entity);
    }

    @Documented(value=" Get outgoing relationships.\n")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingOutgoingRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships" + "/out").entity();
        this.verifyRelReps(2, entity);
    }

    @Documented(value=" Get typed relationships.\n <p/>\n Note that the \"+&+\" needs to be escaped for example when using\n http://curl.haxx.se/[cURL] from the terminal.\n")
    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingAllTypedRelationshipsForANode() throws JsonParseException {
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithRelationships + "/relationships" + "/all/LIKES&HATES").entity();
        this.verifyRelReps(3, entity);
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingIncomingTypedRelationshipsForANode() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithRelationships, "/in/LIKES");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        this.verifyRelReps(1, response.getEntity(String.class));
        response.close();
    }

    @Test
    public void shouldRespondWith200AndListOfRelationshipRepresentationsWhenGettingOutgoingTypedRelationshipsForANode() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithRelationships, "/out/HATES");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        this.verifyRelReps(1, response.getEntity(String.class));
        response.close();
    }

    @Documented(value=" Get relationships on a node without relationships.\n")
    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingAllRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(functionalTestHelper.nodeUri() + "/" + this.nodeWithoutRelationships + "/relationships" + "/all").entity();
        this.verifyRelReps(0, entity);
    }

    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingIncomingRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithoutRelationships, "/in");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        this.verifyRelReps(0, response.getEntity(String.class));
        response.close();
    }

    @Test
    public void shouldRespondWith200AndEmptyListOfRelationshipRepresentationsWhenGettingOutgoingRelationshipsForANodeWithoutRelationships() throws JsonParseException {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nodeWithoutRelationships, "/out");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        this.verifyRelReps(0, response.getEntity(String.class));
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingAllRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/all");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingIncomingRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/in");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWith404WhenGettingOutgoingRelationshipsForNonExistingNode() {
        JaxRsResponse response = this.sendRetrieveRequestToServer(this.nonExistingNode, "/out");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGet200WhenRetrievingValidRelationship() throws DatabaseBlockedException {
        long relationshipId = helper.createRelationship("LIKES");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipUri(relationshipId));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGetARelationshipRepresentationInJsonWhenRetrievingValidRelationship() throws Exception {
        long relationshipId = helper.createRelationship("LIKES");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipUri(relationshipId));
        String entity = response.getEntity(String.class);
        Assert.assertNotNull((Object)entity);
        this.isLegalJson(entity);
        response.close();
    }

    private void isLegalJson(String entity) throws IOException, JsonParseException {
        JsonHelper.jsonToMap((String)entity);
    }
}

