/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;

public class RepresentationFormatRepositoryTest {
    private final RepresentationFormatRepository repository = new RepresentationFormatRepository(null);

    @Test
    public void canProvideJsonFormat() throws Exception {
        this.repository.inputFormat(MediaType.valueOf((String)"application/json"));
    }

    @Test
    public void canProvideUTF8EncodedJsonFormat() throws Exception {
        this.repository.inputFormat(MediaType.valueOf((String)"application/json;charset=UTF-8"));
    }

    @Test(expected=MediaTypeNotSupportedException.class)
    public void canNotGetInputFormatBasedOnWildcardMediaType() throws Exception {
        InputFormat format = this.repository.inputFormat(MediaType.WILDCARD_TYPE);
        format.readValue("foo");
        Assert.fail((String)("Got InputFormat based on wild card type: " + format));
    }
}

